#!/bin/sh
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
TMPLIBDIR = ..
TMPINCDIR = ../../include
CC        = $cc
CFLAGS    = $cflags -I\$(TMPINCDIR) -w
AR        = $ar
LIBDIR    = $libdir
ARCHIVE   = libclu2c.a
OBJ       =\\
	_dir_ent_size.o\\
	_environ.o\\
	_fixup_dir_part.o\\
	_fixup_file_name.o\\
	_home_dir.o\\
	_last_indexc.o\\
	_split_name_part.o\\
	_working_dir.o\\
	any.o\\
	array.o\\
	bool.o\\
	builtin_param.o\\
	char.o\\
	connected_dir.o\\
	date.o\\
	delete_file.o\\
	file_name.o\\
	file_name_fill.o\\
	file_spec.o\\
	get_argv.o\\
	int.o\\
	istream.o\\
	itertype.o\\
	misc.o\\
	now.o\\
	null.o\\
	oneof.o\\
	proctype.o\\
	pstream.o\\
	real.o\\
	record.o\\
	rename_file.o\\
	sequence.o\\
	set_working_dir.o\\
	stream.o\\
	string.o\\
	struct.o\\
	variant.o\\
	working_dir.o\\
	wvec.o

all: $(ARCHIVE)
	cp \$(ARCHIVE) \$(TMPLIBDIR)

$(ARCHIVE): \$(OBJ)
	rm -f \$(ARCHIVE)
	\$(AR) ru \$(ARCHIVE) \$(OBJ)
	ranlib \$(ARCHIVE)

install: \$(ARCHIVE) \$(LIBDIR)
	rm -f \$(LIBDIR)/\$(ARCHIVE)
	cp \$(ARCHIVE) \$(LIBDIR)

\$(LIBDIR):
	mkdir \$(LIBDIR)
	chmod 755 \$(LIBDIR)
	
clean:
	rm -f $(OBJ) $(ARCHIVE) \$(TMPLIBDIR)/\$(ARCHIVE)
EOF
echo ' done'
