/*
 * $Id: stream.h,v 2.0 1992/09/23 12:26:19 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All rights reserved.
 *
 */

/* Representation */

struct rbuf {
    FILE *fp;
    int line;
};

struct wbuf {
    FILE *fp;
    bool buffered;
};

struct tbuf {
    FILE *fp;
    bool ibuffered;
    bool obuffered;
    int line;
    string prompt;
    bool want_prompt;
};

struct sbuf {
    string chars;
    int index;
    int line;
};

struct buf {
    int tag;
    union {
	struct rbuf *read;
	struct wbuf *write;
	struct tbuf *tty;
	struct sbuf *istr;
	array ostr;
	null closed;
    } val;
};

#define BUF_READ	0
#define BUF_WRITE	1
#define BUF_TTY		2
#define BUF_ISTR	3
#define BUF_OSTR	4
#define BUF_CLOSED	5

struct stream_rep {
    file_name name;		/* file name */
    sequence scripts;		/* script files */
    bool scripting;		/* true => script files */
    struct buf *buf;		/* everything else */
};

typedef struct stream_rep *stream;

