/*
 * $Id: sequence.h,v 2.0 1992/09/23 12:26:10 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All rights reserved.
 *
 */

#ifndef _SEQUENCE_
#define _SEQUENCE_

/* Representation */

struct sequence_rep {
    int size;
    elt *buf;
};

typedef struct sequence_rep *sequence;

/* Macros for inline expansion */

/* Bodies of Macro for inline expansion */

#define _sequence_size(x)	(((sequence) (x))->size)
#define _sequence_empty(x)	(((sequence) (x))->size <= 0)

#define _sequence_fetch(x,i)	(((sequence) (x))->buf[(i) - 1])
#define _sequence_bottom(x)	(((sequence) (x))->buf[0])
#define _sequence_top(x)	(((sequence) (x))->buf[((sequence) (x))->size - 1])

/* Flags Which catch the signal raised by Macro for inline expansion */

#define _sequence_bounds(x,i)	(((i)<1) || ((i)>(_sequence_size(x))))

#endif /* _SEQUENCE_ */
