/*
 * $Id: array.h,v 2.0 1992/09/23 12:24:23 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All rights reserved.
 *
 */

#ifndef _ARRAY_
#define _ARRAY_

/* Representation */

struct array_rep{
    int low;                              /* lowewst index */
    int size;                             /* size */
    int base;
    int buf_sz;
    elt *buf;
};

typedef struct array_rep *array ;

/* Macros for inline expansion */

/* Bodies of Macro for inline expansion */

#define _array_low(x)		(((array) (x))->low)
#define _array_size(x)		(((array) (x))->size)
#define _array_high(x)		(((array) (x))->low + ((array) (x))->size - 1)
#define _array_empty(x)		(((array) (x))->size == 0)
#define _array_equal(x,y)	((x) == (y))
#define _array_set_low(x,l)	(((array) (x))->low = (l))

#define _array_fetch(x,i)	(((array) (x))->buf\
				 [((array) (x))->base - ((array) (x))->low + (i)])
#define _array_store(x,i,e)	(((array) (x))->buf\
				 [((array) (x))->base - ((array) (x))->low + (i)]\
				 = (e))
#define _array_remh(x)		(((array) (x))->size--,\
				 ((array) (x))->buf\
				 [((array) (x))->base + ((array) (x))->size])
#define _array_reml(x)		(((array) (x))->size--,\
				 ((array) (x))->low++,\
				 ((array) (x))->buf[((array) x)->base++])
#define _array_bottom(x)	(((array) (x))->buf[((array) (x))->base])
#define _array_top(x)		(((array) (x))->buf\
				 [((array) (x))->base + ((array) (x))->size - 1])

/* Flags Which catch the signal raised by Macro for inline expansion */

#define _array_bounds(x,i)	(((i)<(_array_low(x))) || ((i)>(_array_high(x))))

#endif /* _ARRAY_ */
