#!/bin/sh
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
MAKE     = make
INCDIR   = $incdir
SRCS     = clu2c.h glo.h main.h type.h


install: \$(SRCS) \$(INCDIR)
	@echo -n 'Installing header files ...'
	@(cd \$(INCDIR); rm -f \$(SRCS))
	@cp \$(SRCS) \$(INCDIR)
	@echo ' done'
	(cd blt-in; $(MAKE) install)

\$(INCDIR):
	mkdir \$(INCDIR)
	chmod 755 \$(INCDIR)

EOF
echo ' done'
