/* Array.h.m4 -- template for declarations for generic array objects

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: uunet!ncifcrf.gov!nih-csl!keith
	Internet: keith%nih-csl@ncifcrf.gov
	September, 1985

Function:

m4 macro template for the .h files for arrays of the specified
fundamental type: char, int, short, long, unsigned, float, and double.
For example, to generate the declarations for an array of chars:

	echo "ARRAYDECLARE(Arraychar,char,friend SubString;)" | m4 Array.h.m4 - >Arraychar.h

$Log:	Array_h.m4,v $
Revision 1.3  88/02/04  12:52:03  keith
Make Class class_CLASSNAME const.
Make destructor non-inline.

Revision 1.2  88/01/16  23:37:17  keith
Remove pre-RCS modification history

*/


#ifndef Arraychar_H
#define Arraychar_H

#include "Collection.h"
#include <malloc.h>

overload REALLOC;
overload DELETE;

inline char* REALLOC(char* ptr, unsigned size)
{
	return (char*)realloc((char*)ptr,sizeof(char)*size);
}

inline void DELETE(char* ptr) { free((char*)ptr); }

extern const Class class_Arraychar;
overload Arraychar_reader;

class Arraychar: public Collection {
protected:
	char* v;
	unsigned sz;
	void AllocSizeErr();
	void IndexRangeErr();
// friends go here
	
protected:
	Arraychar(fileDescTy&,Arraychar&);
	Arraychar(istream&,Arraychar&);
	friend	void Arraychar_reader(istream& strm, Object& where);
	friend	void Arraychar_reader(fileDescTy& fd, Object& where);
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
public:
	Arraychar(unsigned size =CLTN_DEFAULT_CAPACITY);
	Arraychar(const Arraychar&);
	~Arraychar();
	char& elem(int i)	{ return v[i]; }
	bool operator!=(const Arraychar& a) { return !(*this==a); }
	void operator=(const Arraychar&);
	bool operator==(const Arraychar&);
	char& operator[](int i)
	  { if ((unsigned)i >= sz) IndexRangeErr(); return v[i]; }
	virtual unsigned capacity();
	virtual void deepenShallowCopy();
	virtual unsigned hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual void printOn(ostream& strm);
	virtual void reSize(unsigned);
	virtual unsigned size();
	virtual void sort();
	virtual const Class* species();
};

#endif

