/* Test class StackProc

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	stackproc.c,v $
 * Revision 2.204  89/10/07  23:51:39  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:51:44  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:24:37  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/05/11  22:25:29  keith
 * Update for R2.0.
 * 
 * Revision 2.200  89/04/24  17:35:58  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:22:35  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 1.2  89/02/08  14:05:05  ted
 * changed names from oops to nihcl
 * 
 * Revision 1.1  89/01/17  16:11:07  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: stackproc.c,v 2.204 89/10/07 23:51:39 keith Stab $";

#include "StackProc.h"
#include "SharedQueue.h"
#include "Scheduler.h"
#include "String.h"

class TestStackProc : public StackProc {
protected:
	TestStackProc(const char* name, stackTy* bottom, int pri, SharedQueue& in, SharedQueue& out);
public:
	static TestStackProc* create(const char* name, int pri, SharedQueue& in, SharedQueue& out);
};

TestStackProc::TestStackProc(const char* pname, stackTy* bottom, int pri, SharedQueue& in, SharedQueue& out)
	: StackProc(pname,bottom,pri)
{
	if (FORK()) return;
	while (YES) {
		Object* msg = in.next();
		cout << "process " << name() << " received " << *msg << endl;
		out.nextPut(*msg);
		cout << "process " << name() << " sent " << *msg << endl;
	}
}

TestStackProc* TestStackProc::create(const char* name, int pri, SharedQueue& in, SharedQueue& out)
{
	auto stackTy bottom;
	return new TestStackProc(name, &bottom, pri, in, out);
}

main(int /* argc */, char** /* argv */)
{
	MAIN_PROCESS(0);
	SharedQueue* q0 = new SharedQueue(2);
	SharedQueue* qin = q0;
	SharedQueue* qout;
	for (int i=1; i <= MAXPRIORITY; i++) {
		String pname = "P";
		pname &= (char)('0'+i);
		qout = new SharedQueue(2);
		TestStackProc::create(pname,i,*qin,*qout);
		qin = qout;
	}
	String& msg = *new String("THE MESSAGE");
	Scheduler::dumpOn(cerr);
	q0->dumpOn(cerr);
	Scheduler::yield();
	q0->nextPut(msg);
	cout << *qout->next() << endl;
}
