/* Test Object dependencies

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	dep.c,v $
 * Revision 2.204  89/10/07  23:50:07  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:50:49  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:21:29  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/11  23:10:57  keith
 * Change OIOistream to OIOin.
 * 
 * Revision 2.200.1.2  89/05/11  22:24:07  keith
 * Update for R2.0.
 * 
 * Revision 2.200.1.1  89/05/03  13:56:37  keith
 * Update for abstract classes.
 * 
 * Revision 2.200  89/04/24  17:33:05  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:19:58  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.8  89/02/08  14:04:06  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.7  88/11/02  17:47:09  keith
 * Fix previous log message.
 * 
 * Revision 2.6  88/11/02  17:41:30  keith
 * Fix readFrom() constructor declarations.
 * 
 * Revision 2.5  88/07/02  23:57:05  keith
 * New DEFINE_CLASS.
 * 
 * Revision 2.4  88/06/02  22:27:00  keith
 * Fix return type of isA().
 * 
 * Revision 2.3  88/05/31  10:42:25  keith
 * Add default argument to PointView::printOn().
 * 
 * Revision 2.2  88/05/30  09:48:35  keith
 * Update for new dumpOn()/printOn() format.
 * 
 * Revision 2.1  88/05/19  17:38:27  keith
 * Fix shallowCopy() to use initialization constructor.
 * 
 * Revision 2.0  88/03/29  13:26:17  keith
 * Version 2 Release 2
 * 
 * Revision 1.2  88/02/04  13:37:54  keith
 * Make extern Class class_CLASSNAME const.
 * 
 * Revision 1.1  88/01/17  22:24:34  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: dep.c,v 2.204 89/10/07 23:50:07 keith Stab $";

#include "Point.h"
#include "OrderedCltn.h"

class MyPoint: public Point {
	DECLARE_MEMBERS(MyPoint);
public:
	MyPoint(int newx, int newy) : Point(newx,newy) {}
	~MyPoint()	{ release(); }
	int x() const	{ return Point::xc; }
	int y() const	{ return Point::yc; }
	int x(int newx)	{ Point::xc = newx; changed(); return Point::xc; }
	int y(int newy)	{ Point::yc = newy; changed(); return Point::yc; }
#ifndef BUG_38
// internal <<AT&T C++ Translator 2.00 06/30/89>> error: bus error (or something nasty like that)
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd& fd)	const	{ Point::storer(fd); }
	virtual	void storer(OIOout& strm) const	{ Point::storer(strm); }
#endif
};

MyPoint::MyPoint(OIOin&) {}

MyPoint::MyPoint(OIOifd&) {}

#define BASE Point
#define BASE_CLASSES Point::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(MyPoint,1,"$Header: dep.c,v 2.204 89/10/07 23:50:07 keith Stab $",NULL,NULL);

class PointView: public VIRTUAL Object {
	DECLARE_MEMBERS(PointView);
	Point* p;
public:
	PointView(Point& newp)	{ p = &newp; p->addDependent(*this); update(*p,*nil); }
	~PointView()		{ p->removeDependent(*this); }
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void update(const Object&, const Object&);
	virtual void printOn(ostream& strm =cout) const;
};

#undef BASE
#define BASE Object
#undef BASE_CLASSES
#define BASE_CLASSES Object::desc()

DEFINE_CLASS(PointView,1,"$Header: dep.c,v 2.204 89/10/07 23:50:07 keith Stab $",NULL,NULL);

int PointView::compare(const Object& a) const { return p->compare(a); }

void PointView::deepenShallowCopy()
{
	p = Point::castdown(p->deepCopy());
}

unsigned PointView::hash() const    { return p->hash(); }

bool PointView::isEqual(const Object& a) const	{ return p->isEqual(a); }

void PointView::update(const Object& p, const Object& /*unused*/)
{
	cout << p.className() << " changed: " << p << endl;
	cout.flush();
}

void PointView::printOn(ostream& strm) const
{
	strm << *p << endl;
}

PointView::PointView(OIOin&) {}

PointView::PointView(OIOifd&) {}

main()
{
	cout << "Test Object Dependencies\n";
	MyPoint p(0,0);
	PointView* v = new PointView(p);
	p.dependents().dumpOn(cout);
	p.x(1); p.y(2);		/* should print changes */
	delete v;
	p.dependents().dumpOn(cout);
	p.x(3); p.y(4);		/* should not print changes */
	v = new PointView(p);
	p.x(5); p.y(6);		/* should print changes */
	p.release();
	p.dependents().dumpOn(cout);
	p.x(7); p.y(8);		/* should not print changes */
}
