#ifndef	LINKEDLIST_H
#define	LINKEDLIST_H

/*$Header: LinkedList.h,v 2.204 89/10/07 23:20:14 keith Stab $*/

/* LinkedList.h -- declarations for singly-linked list

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	LinkedList.h,v $
 * Revision 2.204  89/10/07  23:20:14  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/12  23:43:05  keith
 * Pre-release
 * Move nilLink to class Link
 * Use Link::isListEnd() test.
 * Implement addAfter().
 * 
 * Revision 2.202.1.5  89/08/01  15:08:46  keith
 * Change linkCastdown(Object*) to non-virtual inline.
 * 
 * Revision 2.202.1.4  89/07/30  20:41:34  keith
 * Add linkCastdown() functions.
 * 
 * Revision 2.202.1.3  89/07/11  12:02:24  keith
 * Add static member nilLink.
 * Overload add(), addFirst(), addLast(), and remove() for
 * class Link& arguments.
 * 
 * Revision 2.202.1.2  89/07/10  21:56:28  keith
 * Add copy constructors to fix yacc stack overflows.
 * 
 * Revision 2.202.1.1  89/07/01  21:54:48  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:45  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:14:59  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  23:16:23  keith
 * Make operator[]() return Object* instead of Object*&.
 * Make at() shouldNotImplement.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:20  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:42:24  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:18:08  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  10:59:30  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  09:58:41  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:08:54  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:16:17  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:23  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:07:08  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 */

#include "SeqCltn.h"
#include "Link.h"

class LinkedList: public SeqCltn {
	DECLARE_MEMBERS(LinkedList);
private:
	Link* firstLink;		// pointer to first Link of list
	Link* lastLink;			// pointer to last Link of list
	unsigned count;			// count of items on list
	void errDblLnk(const char* fn, const Link& lnk) const;
	void errEmpty(const char* fn) const;
	void errNotFound(const char* fn, const Object& ob) const;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
protected:
	virtual Link& linkCastdown(Object&) const;
	Link* linkCastdown(Object* p) const   { return &linkCastdown(*p); }
public:
	LinkedList();
#ifndef BUG_TOOBIG
// yacc stack overflow
	LinkedList(const LinkedList&);
#endif
	bool operator!=(const LinkedList& a) const	{ return !(*this==a); }
	bool operator==(const LinkedList&) const;
	Object* operator[](int i);
	const Object *const operator[](int i) const;
	virtual Object* add(Link&);
	virtual Object* add(Object&);
	virtual Object* addAfter(Link&,Link&);
	virtual Object* addAfter(Object&,Object&);
	virtual Collection& addContentsTo(Collection& cltn) const;
	virtual Object* addFirst(Link&);
	virtual Object* addFirst(Object&);
	virtual Object* addLast(Link&);
	virtual Object* addLast(Object&);
	virtual void deepenShallowCopy();
	virtual Object* doNext(Iterator&) const;
	virtual Object* first() const;
	virtual unsigned hash() const;
	virtual bool includes(const Object& ob) const;
 	virtual int indexOf(const Object& ob) const;
	virtual bool isEmpty() const;
	virtual bool isEqual(const Object&) const;
	virtual Object* last() const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Link&);
	virtual Object* remove(const Object&);
	virtual void removeAll();
	virtual Object* removeFirst();
	virtual Object* removeLast();
	virtual void reSize(unsigned newSize);
	virtual unsigned size() const;
	virtual const Class* species() const;
private:				// shouldNotImplement()
	virtual Object*& at(int i);
	virtual const Object *const& at(int i) const;
	virtual void atAllPut(Object& ob);
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
};

#endif
