#ifndef	LINK_H
#define	LINK_H

/*$Header: Link.h,v 2.204 89/10/07 23:20:04 keith Stab $*/

/* Link.h -- declarations for singly-linked list element

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Link.h,v $
 * Revision 2.204  89/10/07  23:20:04  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/12  23:41:56  keith
 * Pre-release
 * Add nilLink and isListEnd().
 * 
 * Revision 2.202.1.1  89/07/01  21:54:40  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:36  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:14:41  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  23:07:07  keith
 * Make all constructors non-inline.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:15  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:42:19  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:57  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:59:16  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:08:44  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:59  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:12  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:06:50  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class LinkedList;

class Link: public VIRTUAL Object {	// abstract class
	DECLARE_MEMBERS(Link);
	Link* next;			// pointer to next Link or nil 
	static Link *const nilLink;	// end of list marker
	friend LinkedList;
protected:
	Link()				{ next = NULL; }
	Link(Link* nextlink)		{ next = nextlink; }
	Link(const Link&)		{ next = NULL; }
public:
	~Link();
	Link* nextLink() const		{ return next; }
	Link* nextLink(Link* nextlink)	{ next = nextlink; return next; }
	bool isListEnd() const		{ return this == nilLink; }
	virtual int compare(const Object&) const = 0;
	virtual Object* copy() const;	// deepCopy()
	virtual void deepenShallowCopy();
	virtual unsigned hash() const = 0;
	virtual bool isEqual(const Object&) const = 0;
	virtual void printOn(ostream& strm =cout) const = 0;
};

#endif
