#ifndef	ITERATOR_H
#define	ITERATOR_H

/*$Header: Iterator.h,v 2.204 89/10/07 23:19:56 keith Stab $*/

/* Iterator.h -- Declarations for Collection Iterators

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892
	December, 1987

$Log:	Iterator.h,v $
 * Revision 2.204  89/10/07  23:19:56  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:27  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/07  14:03:02  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.1  89/07/01  21:54:34  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:28  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:14:26  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  23:04:10  keith
 * Change definition of DO ... OD to use castdown().
 * 
 * Revision 2.201.1.2  89/06/01  23:16:07  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:42:11  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:47  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:59:05  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:08:35  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:36  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:03  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:05:28  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class Collection;

class Iterator: public VIRTUAL Object {
	DECLARE_MEMBERS(Iterator);
	const Collection* cltn;	// Collection being iterated over
public:
	int index;		// index of next Object
	Object*	ptr;		// pointer to current Object or NULL
	unsigned num;		// object number, used by Bags
	Object*	state;		// additional state, e.g., a Stack
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Iterator(const Collection&);
	~Iterator();
	void reset();			// reset to beginning of Collection
	Object*	operator()() const { return ptr; }	// return current object pointer
	Object* operator++();		// advance to next object in Collection
	const Collection* collection() const	{ return cltn; }
	bool operator==(const Iterator&) const;
	bool operator!=(const Iterator& a) const { return !(*this==a); }
	virtual void deepenShallowCopy();	// copy with cltn->deepCopy()
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual const Class* species() const;
private:				// shouldNotImplement()
	virtual	int compare(const Object&) const;
};

#define DO(cltn,cls,arg)\
{ cls* arg; Iterator DO_pos(cltn); while (arg = cls::castdown(DO_pos++)) {
#define OD }}

#endif
