#ifndef	FRACTION_H
#define	FRACTION_H

/*$Header: Fraction.h,v 2.204 89/10/07 23:19:30 keith Stab $*/

/* Fraction.h -- declarations for fractions

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Fraction.h,v $
 * Revision 2.204  89/10/07  23:19:30  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:02  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:54:05  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:02  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:13:35  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  22:53:09  keith
 * Replace value Fraction args by const Fraction& args.
 * 
 * Revision 2.201.1.2  89/06/01  23:15:49  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:41  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:00  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:58:03  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:38  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:34  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:37  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class Fraction: public VIRTUAL Object {
	DECLARE_MEMBERS(Fraction);
public:			// static member functions
	static int gcd(int uu, int vv);
private:
	int n,d;
	Fraction(int num, int den, int dum) {
		n = (dum,num); d = den;
	}
	void parseFraction(istream&);
	void reduce();
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Fraction(int num =0, int den =1);
	Fraction(double);
	Fraction(istream&);
	operator double() const		{ return (double)n/d; }
	int denominator() const		{ return d; }
	int numerator() const		{ return n; }
	
	friend Fraction	operator+(const Fraction&, const Fraction&);
	friend Fraction	operator-(const Fraction& u)  { return Fraction(-u.n,u.d); }
	friend Fraction operator-(const Fraction&, const Fraction&);
	friend Fraction operator*(const Fraction&, const Fraction&);
	friend Fraction operator/(const Fraction&, const Fraction&);
	friend bool	operator<(const Fraction& u, const Fraction& v);
	friend bool	operator>(const Fraction& u, const Fraction& v)		{ return v<u; }
	friend bool	operator<=(const Fraction& u, const Fraction& v);
	friend bool	operator>=(const Fraction& u, const Fraction& v)	{ return v<=u; }
	friend bool	operator==(const Fraction& u, const Fraction& v) const	{ return u.n == v.n && u.d == v.d; }
	friend bool	operator!=(const Fraction& u, const Fraction& v)	{ return !(u==v); }
	
	void operator+=(const Fraction& u)	{ *this = *this + u; }
	void operator-=(const Fraction& u)	{ *this = *this - u; }
	void operator*=(const Fraction& u)	{ *this = *this * u; }
	void operator/=(const Fraction& u)	{ *this = *this / u; }
	
	bool between(const Fraction& min, const Fraction& max) const;
	Fraction max(const Fraction&) const;
	Fraction min(const Fraction&) const;
	
	virtual int compare(const Object&) const;
	virtual void	deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual void scanFrom(istream& strm);
	virtual const Class* species() const;
};

#endif
