#ifndef	FLOAT_H
#define	FLOAT_H

/*$Header: Float.h,v 2.204 89/10/07 23:19:27 keith Stab $*/

/* Float.h -- declarations for Float object

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Float.h,v $
 * Revision 2.204  89/10/07  23:19:27  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:58  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:54:00  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:58  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:13:25  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:15:33  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:34  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:55  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:57:58  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:29  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:29  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:28  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class Float: public VIRTUAL Object {
	DECLARE_MEMBERS(Float);
	double val;
	void parseFloat(istream& strm)	{ strm >> val; }
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Float(double v =0)		{ val = v; }
	Float(istream&);
	double value() const		{ return val; }
	double value(double newval)	{ return val = newval; }
	virtual int compare(const Object&) const;
	virtual void	deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual void scanFrom(istream& strm);
	virtual const Class* species() const;
};

#endif
