/* Float.c -- implementation of Float object

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	December, 1985

Function:
	
Provides an object that contains a double.

$Log:	Float.c,v $
 * Revision 2.204  89/10/07  23:19:25  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:56  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:56  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:56  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/20  22:50:07  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:57:15  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:16:53  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:57:48  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:26  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:27  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:25  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Float.h"
#include "nihclIO.h"

#define	THIS	Float
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Float,1,"$Header: Float.c,v 2.204 89/10/07 23:19:25 keith Stab $",NULL,NULL);

Float::Float(istream& strm)	{ parseFloat(strm); }

int Float::compare(const Object& ob) const
{
	assertArgSpecies(ob,classDesc,"compare");
	register double t = val-castdown(ob).val;
	if (t < 0) return -1;
	if (t > 0) return 1;
	return 0;
}

void Float::deepenShallowCopy()	{}

unsigned Float::hash() const
{
	static union {
		unsigned asint[2];
		double asdouble;
	};
	asdouble = val;
	return asint[0] ^ asint[1];
}

bool Float::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && val==castdown(ob).val;
}

const Class* Float::species() const { return &classDesc; }

void Float::printOn(ostream& strm) const
{
	strm << val;
}

void Float::scanFrom(istream& strm)	{ parseFloat(strm); }

Float::Float(OIOin& strm)
	: BASE(strm)
{
	strm >> val;
}

void Float::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << val;
}

Float::Float(OIOifd& fd)
	: BASE(fd)
{
	fd >> val;
}

void Float::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << val;
}
