#ifndef	EXCEPTION_H
#define	EXCEPTION_H

/*$Header: Exception.h,v 2.204 89/10/07 23:19:19 keith Stab $*/

/* Exception.h -- declarations for NIHCL exception handling

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Exception.h,v $
 * Revision 2.204  89/10/07  23:19:19  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:49  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:47  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:50  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:13:10  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:15:24  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:27  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:49  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:57:39  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:17  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:25  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:22  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"
#include <setjmp.h>

class ExceptionAction : public NIHCL {
public:			// type definitions
	enum exceptionActionTy { ABORT, RAISE };
private:
	unsigned error_code;
	exceptionActionTy old_action;
public:
	ExceptionAction(unsigned error);
	virtual ~ExceptionAction();
};

class RaiseException : public ExceptionAction {
public:
	RaiseException(unsigned error);
};

class AbortException : public ExceptionAction {
public:
	AbortException(unsigned error);
};

class ExceptionTrap : public NIHCL {
public:			// type definitions
	typedef void (*exceptionTrapTy)(unsigned&, int&, ...);
private:
	exceptionTrapTy old_trap;
public:
	ExceptionTrap(exceptionTrapTy xtrap =NULL);
	~ExceptionTrap();
};

class Process;

class ExceptionEnv : public NIHCL {
private:		// static member variables
	static ExceptionEnv* stackTop;
	static ExceptionEnv* lastResort;
	friend Catch;
	friend void RAISE(int exception);
	friend Process;
private:
	ExceptionEnv* prev;
	int exceptionCode;
	jmp_buf env;
public:
	ExceptionEnv() {	// MUST be inline
		prev = stackTop;
		stackTop = this;
		exceptionCode = setjmp(env);
	}
	~ExceptionEnv() { if (stackTop == this) pop(); }
	int code() const { return exceptionCode; }
	void pop()	{ stackTop = prev; }
	void raise(int exception);
};

#define	EXCEPTION_CODE	exception_environment.code()

#define BEGINX { \
	ExceptionEnv exception_environment; \
	if (EXCEPTION_CODE == 0) { \
		
// Statements in the scope of this exception handler block go here.

#define EXCEPTION \
	} \
	else switch(EXCEPTION_CODE) { \

/*
Exception handlers go here; the syntax is that of a switch statement
body.  The exception code that caused this EXCEPTION block to be entered
may be accessed via the macro EXCEPTION_CODE.  The statement
"default:RAISE(EXCEPTION_CODE);" will propagate the current exception up
to the next exception handler block if the exception is not handled by
this block; otherwise, execution continues with the first statement
after this exception block.
*/

#define ENDX \
	}; \
} \

inline void RAISE(int exception)
{
	ExceptionEnv::stackTop->raise(exception);
}

class Catch : public NIHCL {
	static Catch* stackTop;	// top of catch frame stack
	friend Process;
private:
	Catch*	next;
	Catch*	prev;
	Object*	obj;
	friend ExceptionEnv;
public:
	Catch(Object*);
	Catch();		// for construction of catch_stack_top only!
	~Catch();
};

#endif
