#ifndef	BITSET_H
#define	BITSET_H

/*$Header: Bitset.h,v 2.204 89/10/07 23:18:56 keith Stab $*/

/* BitSet.h -- declarations for set of small integers

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Bitset.h,v $
 * Revision 2.204  89/10/07  23:18:56  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:22  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:21  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:23  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:12:29  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  22:16:59  keith
 * Replace BitBoard value args with const BitBoard& args.
 * 
 * Revision 2.201.1.2  89/06/01  23:14:49  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:40:49  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:23  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:56:44  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:07:16  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:13:22  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:55  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:38  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class Bitset: public VIRTUAL Object {
	DECLARE_MEMBERS(Bitset);
public:
	static unsigned bit(unsigned i)	{ return 1<<i; }
protected:
	unsigned m;
	Bitset(unsigned i, char* dum)	{ (dum, m = i); }
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Bitset()		{ m = 0; }
	Bitset(int i1)		{ m = bit(i1); }
	Bitset(int i1, int i2)
		{ m = bit(i1)|bit(i2); }
	Bitset(int i1, int i2, int i3)
		{ m = bit(i1)|bit(i2)|bit(i3); }
	Bitset(int i1, int i2, int i3, int i4)
		{ m = bit(i1)|bit(i2)|bit(i3)|bit(i4); }
	Bitset(int i1, int i2, int i3, int i4, int i5)
		{ m = bit(i1)|bit(i2)|bit(i3)|bit(i4)|bit(i5); }
	Bitset(int i1, int i2, int i3, int i4, int i5, int i6)
		{ m = bit(i1)|bit(i2)|bit(i3)|bit(i4)|bit(i5)|bit(i6); }
	Bitset(int i1, int i2, int i3, int i4, int i5, int i6, int i7)
		{ m = bit(i1)|bit(i2)|bit(i3)|bit(i4)|bit(i5)|bit(i6)|bit(i7); }
	Bitset operator~() const		{ return Bitset(~m, ""); }
	Bitset operator-(const Bitset& n) const	{ return Bitset(m & ~n.m, ""); }
	bool operator>(const Bitset& n) const	{ return m == (m|n.m) && m != n.m; }
	bool operator<(const Bitset& n) const	{ return n.m == (m|n.m) && m != n.m; }
	bool operator>=(const Bitset& n) const	{ return m == (m|n.m); }
	bool operator<=(const Bitset& n) const	{ return n.m == (m|n.m); }
	bool operator==(const Bitset& n) const	{ return m == n.m; }
	bool operator!=(const Bitset& n) const	{ return m != n.m; }
	Bitset operator&(const Bitset& n) const	{ return Bitset(m & n.m, ""); }
	Bitset operator^(const Bitset& n) const { return Bitset(m ^ n.m, ""); }
	Bitset operator|(const Bitset& n) const	{ return Bitset(m | n.m, ""); }
	void operator=(const Bitset& n)		{ m = n.m; }
 	void operator-=(const Bitset& n)	{ m &= ~n.m; }
	void operator&=(const Bitset& n)	{ m &= n.m; }
	void operator^=(const Bitset& n)	{ m ^= n.m; }
	void operator|=(const Bitset& n)	{ m |= n.m; }
	unsigned asMask() const		{ return m; }
	bool includes(unsigned i) const	{ return (m & bit(i)) != 0; }
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEmpty() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual unsigned size() const;
	virtual const Class* species() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
