#ifndef	BAG_H
#define	BAG_H

/*$Header: Bag.h,v 2.204 89/10/07 23:18:48 keith Stab $*/

/* Bag.h -- declarations for Set of Objects with possible duplicates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Bag.h,v $
 * Revision 2.204  89/10/07  23:18:48  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:11  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:10  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:12  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:12:07  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:14:35  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:40:39  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:12  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  10:56:31  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  09:56:56  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:07:01  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:12:59  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:46  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:18  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Collection.h"
#include "Dictionary.h"

class Bag: public Collection {
	DECLARE_MEMBERS(Bag);
	unsigned count;
	Dictionary contents;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Bag(unsigned size =DEFAULT_CAPACITY);
	Bag(const Bag&);
	~Bag();
	Object* addWithOccurrences(Object&, unsigned);
	bool operator!=(const Bag& a) const		{ return !(*this==a); }
	void operator=(const Bag&);
	bool operator==(const Bag&) const;
	virtual	Object*	add(Object&);
	virtual Object*& at(int);
	virtual const Object *const& at(int) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual Object*	doNext(Iterator&) const;
	virtual	void dumpOn(ostream& strm =cerr) const;
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual void reSize(unsigned);
	virtual Object*	remove(const Object&);
	virtual void removeAll();
	virtual unsigned size() const;
	virtual const Class* species() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
