/* Assoc.c -- implementation of key-value association

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Reearch and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:

Objects of class Assoc associate a key object with a value object.  They
are used to implement Dictionaries, which are Sets of Associations.

$Log:	Assoc.c,v $
 * Revision 2.204  89/10/07  23:18:38  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:20:59  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/08  19:10:52  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.1  89/07/01  21:53:01  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:52:59  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:11:39  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/20  21:41:32  keith
 * Add explicit base names to constructor initializer
 * lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:50:44  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:15:57  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:55:52  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:12:06  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:33  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:02:58  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Assoc.h"
#include "nihclIO.h"

#define	THIS	Assoc
#define	BASE	LookupKey
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(Assoc,1,"$Header: Assoc.c,v 2.204 89/10/07 23:18:38 keith Stab $",NULL,NULL);

Assoc::Assoc(Object& newKey, Object& newValue) : BASE(newKey)
{
	avalue = &newValue;
}

Object* Assoc::value() const { return avalue; }

Object* Assoc::value(Object& newvalue)
{
	Object* temp = avalue;
	avalue = &newvalue;
	return temp;
}

void Assoc::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	avalue = avalue->deepCopy();
}

Assoc::Assoc(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	avalue = Object::readFrom(strm);
}

void Assoc::storer(OIOout& strm) const
{
	BASE::storer(strm);
	avalue->storeOn(strm);
}

Assoc::Assoc(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	avalue = Object::readFrom(fd);
}

void Assoc::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	avalue->storeOn(fd);
}
