// ex9-3.c -- Correct handling of member pointers to class instances

// $Header: ex9-3.c,v 2.204 89/10/08 14:43:11 keith Stab $

#include "String.h"

class X {
    String* s;
public:
    X(const char* t="")     { s = new String(t); }
    X(const X& x)           { s = new String(*x.s); }
    void operator=(const X&);
    ~X()                    { delete s; }
    void set(const char* t) { *s = t; }
    friend ostream& operator<<(ostream& strm, X& x) {
        strm << *x.s;
        return strm;
    }
};

void X::operator=(const X& x)
{
    if (this == &x) return;
    delete s;
    s = new String(*x.s);
}

main()
{
    X a = "abc";
    X b = a;
    X c;
    c = a;
    a.set("xyz");
    cout << "a=" << a << endl;
    cout << "b=" << b << endl;
    cout << "c=" << c << endl;
}
