#ifndef ArrayPartialH
#define ArrayPartialH

// ArrayPartial.h -- Array of Partial derivatives

// $Header: ArrayPartial.h,v 2.204 89/10/08 14:38:38 keith Stab $

#include "Partial.h"

class ostream;
class Matrix;
class MatrixRow;

class ArrayPartial {
    Partial* p;
    int sz;
public:
    ArrayPartial(int siz, double*);
    ArrayPartial(int siz, Partial* =0);
    ArrayPartial(const ArrayPartial&);
    ~ArrayPartial();

    void operator=(const ArrayPartial&);
    int size() const { return sz; }
    Partial& at(int Kth) const { return p[Kth]; }
    Partial& operator[](int Kth) const;
    void operator+=(const Matrix&);

    Matrix value() const;
    Matrix jacobian() const;
    ArrayPartial operator+(const ArrayPartial&);
    friend ArrayPartial operator*(double,const ArrayPartial&);
    friend ArrayPartial operator*(const Matrix&,const ArrayPartial&);
    
    virtual void printOn(ostream& strm) const;
};
#endif /*ArrayPartialH*/
