// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef SpinEvent_h
#define SpinEvent_h
#pragma once

//
//	Implement a UNIX event
//

#include <SpinLock.h>

const int EventMaxTimesAround = 1000;

class SpinEvent : public SpinLock {
    short generation;
    short pLoops;
    short state;
    short garcon;	// waiters
public:
    SpinEvent( int pLoops = EventMaxTimesAround );
    ~SpinEvent();
    void rendezvous();
    void waitFor();
    void trigger();
    void waiting();
    int size();
};

inline
SpinEvent::SpinEvent( int l )
{
    pLoops = l;
    state = 1;
    garcon = 0;
}

inline
SpinEvent::~SpinEvent()
{
}

void
SpinEvent::trigger()
{
    reserve();
    garcon = 0;
    generation++;
    release();
}

int
SpinEvent::size()
{
    reserve();
    int was = garcon;
    release();
    return(was);
}

#endif
