// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef OWNEDFACILITYH
#define OWNEDFACILITYH
#pragma once

//
//	OwnedFacility.
//
//	This models a simulation facility. A facility is composed of multiple
//	servers. Servers are utilized for a period of time. The fraction of
//	use of all servers over the total time the facility has existed
//	(or since it was reset) determines the utilization of the facility.
// 

#include <Semaphore.h>
#include <Facility.h>

class Thread;
class ThreadContainer;

typedef Thread *OwnedFacilityKey;

class OwnedFacility : public Facility {

    struct {
	OwnedFacilityKey single;
	OwnedFacilityKey *many;
    } beingServiced;

    virtual void reportErrorState(ostream&);
    void commonReserve(double, OwnedFacilityKey xkey);

    public :

    OwnedFacility(int servers = 1, ThreadContainer *scheduler =0);

    ~OwnedFacility();

    virtual void reserve();
    virtual void release();
    virtual bool reserveNoBlock();

    virtual void reserveKeyed(OwnedFacilityKey xkey);
    virtual void releaseKeyed(OwnedFacilityKey xkey);

    virtual bool isEmpty();

    virtual unsigned queueLength();
    virtual unsigned activeServers();
    virtual unsigned size();

//    virtual void classPrintOn(ostream& s);
};

#endif OWNEDFACILITYH
