// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "LowerBoundedHeap.h"
#include "CpuMultiplexor.h"
#include "stream.h"
#include "assert.h"

LowerBoundedHeap::LowerBoundedHeap(int defaultLength)
    : (defaultLength), lowerBoundLock(0)
{
    //
    // do nothing
    //
}

void LowerBoundedHeap::add(AwesimeHeapItem &t) {
    LockedHeap::add(t);
    lowerBoundLock.release();
}

bool
LowerBoundedHeap::remove(AwesimeHeapItem &item) {

    (void) lowerBoundLock.reserve();
    bool ok = LockedHeap::remove(item);
    //
    //	The remove had better have worked, or there's something screwy
    //  with the semaphores.
    //
    assert(ok);
    return(ok);
}

bool
LowerBoundedHeap::doDelete(AwesimeHeapIndex& )
{
    assert(0);
    return(0);
}

unsigned int
LowerBoundedHeap::size()
{
    return(AwesimeHeap::size());
}

void LowerBoundedHeap::classPrintOn(ostream& s)
{
    s << "[LowerBoundedHeap " ;
    s << "\tSemaphore\n";
//    s << lowerBoundLock;
    s << "\n";
    s << "\tHeap";
    AwesimeHeap::classPrintOn(s);
    s << "\n]\n" ;
}
