// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef _LowerBoundedFifo_h
#define _LowerBoundedFifo_h
#pragma once

#include <Semaphore.h>
#include <LockedFifo.h>
#include <FifoScheduler.h>

class LowerBoundedFifo : public LockedFifo {

protected:
    FifoScheduler lowerBoundLockFifo;
    Semaphore lowerBoundLock;
    
public:
    
    LowerBoundedFifo(int defaultLength = 0);
    
    virtual void add(AwesimeFifoItem *t);
    virtual bool remove(AwesimeFifoItem *item);
    virtual bool removeNoBlock(AwesimeFifoItem *item);

    virtual bool removeIfFound(AwesimeFifoItem *item);
    
    virtual bool doDelete(AwesimeFifoIndex& index);
    
    virtual unsigned size();
    
    virtual void classPrintOn(ostream& s);
};

#endif /* _LowerBoundedFifo_h */
