// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef Histogram_h
#define Histogram_h
#pragma once

#include <SampleHistogram.h>
#include <stream.h>
#include <assert.h>

class Histogram : public SampleHistogram {

public:
    Histogram(double, double, double );
    virtual void classPrintOn(ostream&);
};

static inline
Histogram::Histogram(double low, double hi, double bucketWidth = -1.0)
    : (low, hi, bucketWidth)
{
    // empty
}

inline ostream&
operator<<(ostream& strm, Histogram& ob)
{
    ob.classPrintOn(strm);
    return strm;
}

#endif /* Histogram_h */
