// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef BoundedFifo_h
#define BoundedFifo_h
#pragma once

#include <LowerBoundedFifo.h>

//
// A BoundedFifo is a LowerBoundedFifo that also has an upper bound.
// The members are implemented over the LowerBoundedFifo members to
// reduce the number of calls.
//
class BoundedFifo : public LowerBoundedFifo {

protected:
    int pMaxLength;
    FifoScheduler upperBoundLockFifo;
    Semaphore upperBoundLock;

public:

    BoundedFifo(int xmaxLength = 1, int defaultLength = 0);

    virtual void add(AwesimeFifoItem *t);
    virtual bool remove(AwesimeFifoItem *item);
    virtual bool removeNoBlock(AwesimeFifoItem *item);

    virtual bool removeIfFound(AwesimeFifoItem *item);

    virtual bool doDelete(AwesimeFifoIndex& index);

    virtual unsigned size();
};
		     
#endif BoundedFifo_h
