// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef Barrier_h
#define Barrier_h
#pragma once

//
//	Barrier.h
//	The barrier is initially closed.
// 

#include <ReserveByException.h>
#include <FifoScheduler.h>
#include <SpinLock.h>

class Barrier : public ReserveByException {
    SpinLock lock;
    short pHeight;
    short pCount;
    short pLoops;
    short generation;

    FifoScheduler pPileOfThreads;
    
    void releaseAll();
    
private:
    virtual int reserveByException(Thread *byWho);
    
public:
    
    Barrier(int height, int loops = DefaultBarrierLoops);
    virtual ~Barrier();

    void rendezvous();

    //
    // lowerBarrier forces all waiting jobs to continue
    //
    void lowerBarrier();

    //
    // Changing the height of the barrier can cause people to continue
    // if it is lowered below the current pCount.
    //
    int height();
    void height(int h);
};

inline
Barrier::Barrier( int h, int l )
{
    pHeight = h;
    pLoops = l;
    pCount = 0;
    generation = 0;
}

inline int
Barrier::height()
{
    return(pHeight);
}

#endif /* Barrier_h */
