// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#include "SimulationMultiplexor.h"
#include "CpuMultiplexorP.h"
#include "CpuMuxExceptions.h"
#include "HardwareContextP.h"
#include "SpinLock.h"
#include "SpinBarrier.h"
#include "SpinFetchAndOp.h"
#include "AwesimeHeap.h"

#include "Thread.h"

#include "TimeSchedulerSplayPQ.h"

#include "ReserveByException.h"
#include <math.h>

#include "Debug.h"

static const int NOTREACHED = 0;

SimulationMultiplexor *ThisSimulationMultiplexor;

double CurrentSimulatedTime = 0.0;

extern int CpuMuxDebugFlag;

SimulationMultiplexor::SimulationMultiplexor(int debug)
{
    ThisSimulationMultiplexor = this;
    CpuMuxDebugFlag = debug;
}

SimulationMultiplexor::~SimulationMultiplexor()
{
    // empty
}

//void
//SimulationMultiplexor::allocateLocalEventStructures(int newIYam, int outOf)
//{
//    // empty
//}

void
SimulationMultiplexor::allocateEventStructures(int, int)
{
    assert( NOTREACHED );
}

void
SimulationMultiplexor::deallocateEventStructures()
{
    assert( NOTREACHED );
}

#ifdef UNDEF
void
SimulationMultiplexor::fireItUp( int cpus, unsigned )
{
    warmThePot( cpus );
    stirItAround();
    coolItDown();
}

void
SimulationMultiplexor::warmThePot(int)
{
    assert( NOTREACHED );
}

void
SimulationMultiplexor::stirItAround()
{
    assert( NOTREACHED );
}

void
SimulationMultiplexor::coolItDown()
{
    assert( NOTREACHED );
}
#endif

void
SimulationMultiplexor::addAt(Thread *who, double when)
{
    if (when <= CurrentSimulatedTime) {
	ThisCpu -> add(who);
    }
    else {
#ifndef NDEBUG
	if (CpuMuxDebugFlag) {
	    CpuCerrLock.reserve();
	    cerr << ThisCpu -> name();
	    cerr << " add " << who -> name();
	    cerr << " to pending for " << when << "\n";
	    CpuCerrLock.release();
	}
#endif /* NDEBUG */
	//
	// Add them to pending events
	//
	TimeScheduler item(who,when);
	DEBUG_START;
	cerr << ThisCpu -> name();
	cerr << " item added is " << hex(long(item.thread()));
	cerr << " " << item.time() << "\n";
	DEBUG_END;
	myPendingEvents->enq( item );
    }
}

void
SimulationMultiplexor::addWithDelay(Thread *who, double delay)
{
    delay += CurrentSimulatedTime;
    addAt(who, delay);
}

//
//	Advance time. Assumes all other CPUs are idle, so no locking
//	on event structures is needed.
//
int
SimulationMultiplexor::advanceTime()
{
    assert( NOTREACHED );
    return( 0 );
}

void
SimulationMultiplexor::await(double when)
{
    DEBUG_START;
    cerr << ThisCpu -> name() << "await " << when;
    cerr << " at " << CurrentSimulatedTime << "\n";
    DEBUG_END;

    if (when > CurrentSimulatedTime) {

	addAt( ThisCpu -> currentThread, when );

	Thread *next = ThisCpu -> remove();

	if ( next == 0 ) {
	    ThisCpu -> raise( &(ThisCpu -> iveSuspendedException) );
	} else {
	    Thread *from = ThisCpu -> currentThread;
	    ThisCpu -> currentThread = next;

#ifndef NDEBUG
	    if (CpuMuxDebugFlag) {
		CpuCerrLock.reserve();
		cerr << ThisCpu -> name();
		cerr << " switch to " << ThisCpu -> currentThread -> name() << "\n";
		CpuCerrLock.release();
	    }
#endif	/* NDEBUG */
	    from -> pContext.switchContext ( &(ThisCpu -> currentThread -> pContext) );
	}
    }
}

void
SimulationMultiplexor::hold(double holdFor)
{
    if (holdFor > 0) {
	DEBUG_START;
	cerr << ThisCpu -> name() << "hold for " << holdFor;
	cerr << " at " << CurrentSimulatedTime << "\n";
	DEBUG_END;

	await( CurrentSimulatedTime + holdFor );
    }
}
