// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#include "MonitorSimMux.h"
#include "SpinBarrier.h"
#include "Statistic.h"
#include "SpinFetchAndOp.h"
#include "AwesimeConfig.h"

static SpinLock statsLock;
static Statistic ThreadsPerTick;
static int threadsThisTick[MaxCpuMultiplexors];

extern int CpuMuxDebugFlag;

MonitorSimMux *ThisMonitorSimMux;

MonitorSimMux::MonitorSimMux(int debug, int maxloops) : (debug, maxloops)
{
    CpuMultiplexor::pNameTemplate = "MonitorSimMux";
    ThisMonitorSimMux = this;
    sprintf(CpuMultiplexor::nameSpace, "[%s-%d] ",
	    CpuMultiplexor::pNameTemplate, CpuMultiplexor::iYam);
    CpuMultiplexor::pName = CpuMultiplexor::nameSpace;
}

void
MonitorSimMux::stirItAround()
{
    while( ! *MultiSimMux::terminated )
    {
	MultiSimMux::stirItAround();
#ifndef NDEBUG
	if (CpuMuxDebugFlag) {
	    CpuCerrLock.reserve();
	    cerr << name() << "Finished with current batch, advance time\n";
	    CpuCerrLock.release();
	}
#endif /*NDEBUG*/
	int added = advanceTime();

	threadsThisTick[MultiSimMux::iYam] += added;

	cpuBarrier -> rendezvous();

	if (MultiSimMux::iYam == 0) {
	    int total = 0;
	    for (int i = 0 ; i < CpuMultiplexors; i++ ) {
		total += threadsThisTick[i];
		threadsThisTick[i] = 0;
	    }
	    double dtotal = double(total);
	    ThreadsPerTick += dtotal;
	}
    }
}

void
MonitorSimMux::coolItDown()
{
    MultiSimMux::coolItDown();
    
    CpuCerrLock.reserve();
    cerr << name() << "Statistics for threads per tick\n";
    cerr << name() << ThreadsPerTick << "\n";
    cerr << name() << "Min = " << ThreadsPerTick.min() << "\n";
    cerr << name() << "Max = " << ThreadsPerTick.max() << "\n";
    CpuCerrLock.release();
}

Statistic *
MonitorSimMux::threadsPerTick()
{
    return (&ThreadsPerTick);
}
