/*
 *****************************************************************************
 *                                                                           *
 *  UNIVERSITY OF LOWELL Motif/C++ Binding				     *	
 *                                                                           *
 *  COPYRIGHT (c) 1990 BY  UNIVERSITY OF LOWELL, DEPARTMENT OF COMPUTER      *
 *  SCIENCE, LOWELL, MA 01854                                                *
 *                                                                           *
 *  LICENSED MATERIAL - PROGRAM PROPERTY OF UNIVERSITY OF LOWELL. ALL RIGHTS *
 *  RESERVED.                                                                *
 *                                                                           *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED    *
 *  ONLY  IN  ACCORDANCE  WITH  THE TERMS OF  SUCH  LICENSE  AND WITH THE    *
 *  INCLUSION OF THE  ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER    *
 *  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY    *
 *  OTHER PERSON.  NO TITLE TO  OR OWNERSHIP OF  THE  SOFTWARE  IS HEREBY    *
 *  TRANSFERRED.                                                             *
 *                                                                           *
 *  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE    *
 *  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY UNIVERSITY OF LOWELL    *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * File Name      :                                                          *
 * Author         :                                                          *
 * Created        :                                                          *
 * Description    :                                                          *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 * Edit History   :                                                          *
 * date         who                     what                                 *
 *                                                                           *
 *****************************************************************************
 */
static char rcsid[] = "$Header: XMObject.cc,v 1.7 89/12/17 14:16:38 bmontagu Exp $";
/*
//-----------------------------------------------------------------------------
//
// $Source: /usr/proj/grl/motifplb/design_review_1_efforts/lib_1/XMObject.cc,v $
// $Revision: 1.7 $
// $State: Exp $
// $Author: bmontagu $
// $Date: 89/12/17 14:16:38 $
// $Locker:  $
//
// $Log:	XMObject.cc,v $
Revision 1.7  89/12/17  14:16:38  bmontagu
Disabled HASH_DEBUG diagnostics.

Revision 1.6  89/12/05  09:44:03  grlcr
Added Xt calls

Revision 1.5  89/12/01  09:04:51  bmontagu
End intrinsics pass

Revision 1.4  89/11/15  12:58:11  grlcr
*** empty log message ***

Revision 1.3  89/11/08  10:37:47  grlcr
*** empty log message ***

Revision 1.2  89/11/03  18:19:55  grlcr
major reworking

Revision 1.1  89/11/02  11:53:08  motifplb
Initial revision

// ***** Created Oct 18, 1989 by Krishnan *****
// ***** grlcr: reworked, Nov 3
//-----------------------------------------------------------------------------
*/

#include <stream.h>

#include "XMObject.hh"

#define  HASH_DEBUG    0

  static class_bind* cbind[128];
  void      cb_associate     (Widget, XMObject*);
  void      cb_remove        (Widget);
  XMObject* cb_locate_object (Widget);

// ---------------------------------------------------------------------------
   XMObject::XMObject ()
// ---------------------------------------------------------------------------
{
}

// ---------------------------------------------------------------------------
   XMObject::~XMObject ()
// ---------------------------------------------------------------------------
{
   cb_remove( w );          // Remove association between widget & c++ object.
   XtDestroyWidget (this->get_widget ());

printf ("Destroying widget : %x\n", w);

}

BIND_CALLBACK( XMObject, set_entry_destroyCallback, XmNdestroyCallback )

// ---------------------------------------------------------------------------
   void XMObject::set_immediate_ON ()
// ---------------------------------------------------------------------------
{
 immediate = 1;
}

// ---------------------------------------------------------------------------
   void XMObject::set_immediate_OFF ()
// ---------------------------------------------------------------------------
{
 immediate = 0;
}
// ---------------------------------------------------------------------------
   void XMObject::start_transaction ()
// ---------------------------------------------------------------------------
{
 immediate = 0;
}

// ---------------------------------------------------------------------------
   void XMObject::end_transaction ()
// ---------------------------------------------------------------------------
{
 set ();
 immediate = 1;
}

// ---------------------------------------------------------------------------
   void XMObject::set ()
// ---------------------------------------------------------------------------
{
 XtSetValues (w, args, args_count);
 args_count = 0;
}

// ---------------------------------------------------------------------------
   void XMObject::get ()
// ---------------------------------------------------------------------------
{
 XtGetValues (w, args, args_count);
 args_count = 0;
}

// ---------------------------------------------------------------------------
   void XMObject::AddCallback (String s, XtCallbackProc xcp, caddr_t ct)
// ---------------------------------------------------------------------------
{
 XtAddCallback (w, s, xcp, ct);
}

// ---------------------------------------------------------------------------
   void XMObject::AddCallbacks (String s, XtCallbackList xcl)
// ---------------------------------------------------------------------------
{
 XtAddCallbacks (w, s, xcl);
}

// ---------------------------------------------------------------------------
   void XMObject::AddEventHandler (EventMask em, Boolean b,
                                   XtEventHandler xeh, caddr_t ct)
// ---------------------------------------------------------------------------
{
 XtAddEventHandler (w, em, b, xeh, ct);
}

// ---------------------------------------------------------------------------
   void XMObject::AddGrab (Boolean b1, Boolean b2)
// ---------------------------------------------------------------------------
{
 XtAddGrab (w, b1, b2);
}

// ---------------------------------------------------------------------------
   void XMObject::AddRawEventHandler (EventMask em, Boolean b,
                                      XtEventHandler xeh, caddr_t ct)
// ---------------------------------------------------------------------------
{
 XtAddRawEventHandler (w, em, b, xeh, ct);
}

// ---------------------------------------------------------------------------
   XtAppContext XMObject::ApplicationContext ()
// ---------------------------------------------------------------------------
{
 return (XtWidgetToApplicationContext (w));
}

// ---------------------------------------------------------------------------
   void XMObject::AugmentTranslations (XtTranslations xts)
// ---------------------------------------------------------------------------
{
 XtAugmentTranslations (w, xts);
}

// ---------------------------------------------------------------------------
   EventMask XMObject::BuildEventMask ()
// ---------------------------------------------------------------------------
{
 return (XtBuildEventMask (w));
}

// ---------------------------------------------------------------------------
   void XMObject::CallCallbacks (String s, caddr_t ct)
// ---------------------------------------------------------------------------
{
 XtCallCallbacks (w, s, ct);
}

// ---------------------------------------------------------------------------
   void XMObject::CallbackPopdown (caddr_t ct1, caddr_t ct2)
// ---------------------------------------------------------------------------
{
 XtCallbackPopdown (w, ct1, ct2);
}

// ---------------------------------------------------------------------------
   void XMObject::CallbackNone (caddr_t ct1, caddr_t ct2)
// ---------------------------------------------------------------------------
{
 XtCallbackNone (w, ct1, ct2);
}

// ---------------------------------------------------------------------------
   void XMObject::CallbackNonexclusive (caddr_t ct1, caddr_t ct2)
// ---------------------------------------------------------------------------
{
 XtCallbackNonexclusive (w, ct1, ct2);
}

// ---------------------------------------------------------------------------
   void XMObject::CallbackExclusive (caddr_t ct1, caddr_t ct2)
// ---------------------------------------------------------------------------
{
 XtCallbackExclusive (w, ct1, ct2);
}

// ---------------------------------------------------------------------------
   void XMObject::Configure (Position p1, Position p2, Dimension d1,
                             Dimension d2, Dimension d3)
// ---------------------------------------------------------------------------
{
 XtConfigureWidget (w, p1, p2, d1, d2, d3);
}

// ---------------------------------------------------------------------------
   void XMObject::Convert (String s1, XrmValuePtr xvp1,
                           String s2, XrmValuePtr xvp2)
// ---------------------------------------------------------------------------
{
 XtConvert (w, s1, xvp1, s2, xvp2);
}

// ---------------------------------------------------------------------------
   void XMObject::CreateWindow (u_int ui, Visual* v,
                                XtValueMask xvm, XSetWindowAttributes* xswa)
// ---------------------------------------------------------------------------
{
 XtCreateWindow (w, ui, v, xvm, xswa);
}

// ---------------------------------------------------------------------------
   void XMObject::DisownSelection (Atom a, Time t)
// ---------------------------------------------------------------------------
{
 XtDisownSelection (w, a, t);
}

// ---------------------------------------------------------------------------
   Display* XMObject::display ()
// ---------------------------------------------------------------------------
{
 return (XtDisplay (w));
}

// ---------------------------------------------------------------------------
   void XMObject::GetApplicationResources (caddr_t ct, XtResourceList xrl,
                                   Cardinal c1, ArgList al, Cardinal c2)
// ---------------------------------------------------------------------------
{
 XtGetApplicationResources (w, ct, xrl, c1, al, c2);
}

// ---------------------------------------------------------------------------
   GC XMObject::GetGC (XtGCMask xgcm, XGCValues* xgcv)
// ---------------------------------------------------------------------------
{
 return (XtGetGC (w, xgcm, xgcv));
}

// ---------------------------------------------------------------------------
   void XMObject::GetSelectionValue (Atom a1, Atom a2, 
                                     XtSelectionCallbackProc xscp,
                                     caddr_t ct, Time t)
// ---------------------------------------------------------------------------
{
 XtGetSelectionValue (w, a1, a2, xscp, ct, t);
}

// ---------------------------------------------------------------------------
   void XMObject::GetSelectionValues (Atom a1, Atom* a2, int i,
                                      XtSelectionCallbackProc xscp,
                                      XtPointer* ct, Time t)
// ---------------------------------------------------------------------------
{
  XtGetSelectionValues (w, a1, a2, i, xscp, ct, t);
}

// ---------------------------------------------------------------------------
   void XMObject::GetSubresources (caddr_t ct, String s1, String s2,
                                   XtResourceList xrl, Cardinal c2,
                                   ArgList al, Cardinal c1)
// ---------------------------------------------------------------------------
{
 XtGetSubresources (w, ct, s1, s2, xrl, c2, al, c1);
}

// ---------------------------------------------------------------------------
   void XMObject::GetValues (ArgList al, Cardinal c)
// ---------------------------------------------------------------------------
{
 XtGetValues (w, al, c);
}

// ---------------------------------------------------------------------------
   void XMObject::GrabKey (KeyCode k, u_int ui, Boolean b, int i1, int i2)
// ---------------------------------------------------------------------------
{
 XtGrabKey (w, k, ui, b, i1, i2);
}

// ---------------------------------------------------------------------------
   int XMObject::GrabKeyboard (Boolean b, int i1, int i2, Time t)
// ---------------------------------------------------------------------------
{
 return (XtGrabKeyboard (w, b, i1, i2, t));
}

// ---------------------------------------------------------------------------
   XtCallbackStatus XMObject::HasCallbacks (String s)
// ---------------------------------------------------------------------------
{
 return (XtHasCallbacks (w, s));
}

// ---------------------------------------------------------------------------
   void XMObject::InstallAccelerators (XMObject* o)
// ---------------------------------------------------------------------------
{
 XtInstallAccelerators (w, o->get_widget());
}

// ---------------------------------------------------------------------------
   void XMObject::InstallAllAccelerators (XMObject* o)
// ---------------------------------------------------------------------------
{
 XtInstallAllAccelerators (w, o->get_widget());
}

// ---------------------------------------------------------------------------
   Boolean XMObject::IsComposite ()
// ---------------------------------------------------------------------------
{
 return (XtIsComposite (w));
}

// ---------------------------------------------------------------------------
   Boolean XMObject::IsManaged ()
// ---------------------------------------------------------------------------
{
 return (XtIsManaged (w));
}

// ---------------------------------------------------------------------------
   Boolean XMObject::IsRealized ()
// ---------------------------------------------------------------------------
{
 return (XtIsRealized (w));
}

// ---------------------------------------------------------------------------
   Boolean XMObject::IsSensitive ()
// ---------------------------------------------------------------------------
{
 return (XtIsSensitive (w));
}

// ---------------------------------------------------------------------------
   XtGeometryResult XMObject::MakeGeometryRequest (XtWidgetGeometry* xwg1,
                                                   XtWidgetGeometry* xwg2)
// ---------------------------------------------------------------------------
{
 return (XtMakeGeometryRequest (w, xwg1, xwg2));
}

// ---------------------------------------------------------------------------
   XtGeometryResult XMObject::MakeResizeRequest (Dimension d1, Dimension d2,
                                                 Dimension* d3, Dimension* d4)
// ---------------------------------------------------------------------------
{
 return (XtMakeResizeRequest (w, d1, d2, d3, d4));
}

// ---------------------------------------------------------------------------
   void XMObject::Manage ()
// ---------------------------------------------------------------------------
{
 XtManageChild (w);
}

// ---------------------------------------------------------------------------
   void XMObject::Map ()
// ---------------------------------------------------------------------------
{
 XtMapWidget (w);
}

// ---------------------------------------------------------------------------
   void XMObject::Move (Position p1, Position p2)
// ---------------------------------------------------------------------------
{
 XtMoveWidget (w, p1, p2);
}

// ---------------------------------------------------------------------------
   XMObject* XMObject::NameToWidget (String s)
// ---------------------------------------------------------------------------
{
 return (cb_locate_object (XtNameToWidget (w, s)));
}

// ---------------------------------------------------------------------------
   void XMObject::OverrideTranslations (XtTranslations xt)
// ---------------------------------------------------------------------------
{
 XtOverrideTranslations (w, xt);
}

// ---------------------------------------------------------------------------
   Boolean XMObject::OwnSelection (Atom a, Time t, XtConvertSelectionProc xcsp,
                            XtLoseSelectionProc xlsp, XtSelectionDoneProc xsdp)
// ---------------------------------------------------------------------------
{
 return (XtOwnSelection (w, a, t, xcsp, xlsp, xsdp));
}

// ---------------------------------------------------------------------------
   XMObject* XMObject::Parent ()
// ---------------------------------------------------------------------------
{
 //return (cb_locate_object (XtParent (w)));
 Widget temp;
 XMObject* temp1;

 if ((temp = XtParent (w)) == NULL)       // parent widget doesnt exist
    return (NULL);
 else
    if ((temp1 = cb_locate_object (temp)) != NULL) // return parent object
       return (temp1);
    else
       {                                  // parent object is not registered
        XMObject* temp2 = new XMObject;          // so create one and register it
	temp2->w = temp;                   // this case occurs in cases like
	cb_associate (temp, temp2);      // XMScrolledList etc..
	return (temp2);
       }

}

// ---------------------------------------------------------------------------
   void XMObject::Popdown ()
// ---------------------------------------------------------------------------
{
 XtPopdown (w);
}

// ---------------------------------------------------------------------------
   void XMObject::Popup (XtGrabKind xgk)
// ---------------------------------------------------------------------------
{
 XtPopup (w, xgk);
}

// ---------------------------------------------------------------------------
   XtGeometryResult XMObject::QueryGeometry (XtWidgetGeometry* xwg1,
                                             XtWidgetGeometry* xwg2)
// ---------------------------------------------------------------------------
{
 return (XtQueryGeometry (w, xwg1, xwg2));
}

// ---------------------------------------------------------------------------
   void XMObject::Realize ()
// ---------------------------------------------------------------------------
{
 XtRealizeWidget (w);
}

// ---------------------------------------------------------------------------
   void XMObject::ReleaseGC (GC gc)
// ---------------------------------------------------------------------------
{
 XtReleaseGC (w, gc);
}

// ---------------------------------------------------------------------------
   void XMObject::RemoveAllCallbacks (String s)
// ---------------------------------------------------------------------------
{
 XtRemoveAllCallbacks (w, s);
}

// ---------------------------------------------------------------------------
   void XMObject::RemoveCallback (String s, XtCallbackProc xcp, caddr_t ct)
// ---------------------------------------------------------------------------
{
 XtRemoveCallback (w, s, xcp, ct);
}

// ---------------------------------------------------------------------------
   void XMObject::RemoveCallbacks (String s, XtCallbackList xcl)
// ---------------------------------------------------------------------------
{
 XtRemoveCallbacks (w, s, xcl);
}

// ---------------------------------------------------------------------------
   void XMObject::RemoveEventHandler (EventMask em, Boolean b,
                                      XtEventHandler xeh, caddr_t ct)
// ---------------------------------------------------------------------------
{
 XtRemoveEventHandler (w, em, b, xeh, ct);
}

// ---------------------------------------------------------------------------
   void XMObject::RemoveGrab ()
// ---------------------------------------------------------------------------
{
 XtRemoveGrab (w);
}

// ---------------------------------------------------------------------------
   void XMObject::RemoveRawEventHandler (EventMask em, Boolean b,
                                         XtEventHandler xeh, caddr_t ct)
// ---------------------------------------------------------------------------
{
 XtRemoveRawEventHandler (w, em, b, xeh, ct);
}

// ---------------------------------------------------------------------------
   void XMObject::Resize (Dimension d1, Dimension d2, Dimension d3)
// ---------------------------------------------------------------------------
{
 XtResizeWidget (w, d1, d2, d3);
}

// ---------------------------------------------------------------------------
   void XMObject::ResizeWindow (Dimension d1, Dimension d2)
// ---------------------------------------------------------------------------
{
 Display* display = XtDisplay (w);
 XResizeWindow (display, XtWindow (w), d1, d2);
}

// ---------------------------------------------------------------------------
   Screen* XMObject::screen ()
// ---------------------------------------------------------------------------
{
 return (XtScreen (w));
}

// ---------------------------------------------------------------------------
   void XMObject::SetKeyboardFocus (XMObject* o)
// ---------------------------------------------------------------------------
{
 XtSetKeyboardFocus (w, o->get_widget());
}

// ---------------------------------------------------------------------------
   void XMObject::SetMappedWhenManaged (Boolean b)
// ---------------------------------------------------------------------------
{
 XtSetMappedWhenManaged (w, b);
}

// ---------------------------------------------------------------------------
   void XMObject::SetSensitive (Boolean b)
// ---------------------------------------------------------------------------
{
 XtSetSensitive (w, b);
}

// ---------------------------------------------------------------------------
   void XMObject::SetValues (ArgList al, Cardinal c)
// ---------------------------------------------------------------------------
{
 XtSetValues (w, al, c);
}

// ---------------------------------------------------------------------------
   void XMObject::TranslateCoords (Position p1, Position p2,
                                   Position* p3, Position* p4)
// ---------------------------------------------------------------------------
{
 XtTranslateCoords (w, p1, p2, p3, p4);
}

// ---------------------------------------------------------------------------
   void XMObject::UngrabKey (KeyCode kc, u_int ui)
// ---------------------------------------------------------------------------
{
 XtUngrabKey (w, kc, ui);
}

// ---------------------------------------------------------------------------
   void XMObject::UngrabKeyboard (Time t)
// ---------------------------------------------------------------------------
{
 XtUngrabKeyboard (w, t);
}

// ---------------------------------------------------------------------------
   void XMObject::UninstallTranslations ()
// ---------------------------------------------------------------------------
{
 XtUninstallTranslations (w);
}

// ---------------------------------------------------------------------------
   void XMObject::Unmanage ()
// ---------------------------------------------------------------------------
{
 XtUnmanageChild (w);
}

// ---------------------------------------------------------------------------
   void XMObject::Unmap ()
// ---------------------------------------------------------------------------
{
 XtUnmapWidget (w);
}

// ---------------------------------------------------------------------------
   void XMObject::Unrealize ()
// ---------------------------------------------------------------------------
{
 XtUnrealizeWidget (w);
}

// ---------------------------------------------------------------------------
   Window XMObject::window ()
// ---------------------------------------------------------------------------
{
 XtWindow (w);
}




/* -------------------------------------------------------*\
struct class_bind {
     struct class_bind  *cb_flink;
     Widget              cb_widget;
     XMObject           *cb_object;
};
      static class_bind *cbind[128];

      associate( Widget, XMObject *);
      remove( Widget );
      XMObject *locate_object( Widget );
\* -------------------------------------------------------*/

// ---------------------------------------------------------------------------
void cb_associate( Widget wid, XMObject* obj)
// ---------------------------------------------------------------------------
{
register struct class_bind  *cb;
register long      idx;

  idx = 0x0000007F & ((long)wid);
  
  cb  = (struct class_bind*)malloc( sizeof( struct class_bind ) );
  cb->cb_widget = wid;
  cb->cb_object = obj;
  cb->cb_flink  = cbind[ idx ];

  cbind[ idx ]  = cb;

#if HASH_DEBUG
   cout << form( "HASH: associate: wid=%lx with obj=%lx at idx=%d",
                                  wid, obj, idx );
#endif

}

// ---------------------------------------------------------------------------
void cb_remove( Widget wid )
// ---------------------------------------------------------------------------
{
register struct class_bind  *cb,*old_cb;
register long      idx;

#if HASH_DEBUG
   cout<<form( "HASH: remove: wid=%lx ", wid );
#endif


  idx = 0x0000007F & ((long)wid);

  cb  = cbind[ idx ];
  if( !cb ) {
      cout << "C++Motif binding: XMObject: Class binding hash table error!";
      exit( 1 );
  }

  // ---------- Special case 1st block, and "prime pump" for scan.
  if( cb->cb_widget == wid ) {
      cbind[ idx ] = cb->cb_flink;
#if HASH_DEBUG
       cout<<form( "HASH:remove(1): found cb at idx=%d ", idx );
#endif
      free( cb );
      return;
  } else {
      old_cb = cb;
      cb     = cb->cb_flink;
  }

  // ----------- Now walk the chain, search for block to remove.
  for(;;) {
     if( cb ) {
        if( cb->cb_widget == wid ) {
            old_cb->cb_flink = cb->cb_flink;
#if HASH_DEBUG
       cout<<form( "HASH:remove(2): found cb at idx=%d ", idx );
#endif
	    free( cb );
	    return;
	}
     } else {
	cout << "C++Motif binding: XMObject: Fatal class binding hash table err!";
        exit( 1 );
     }

     old_cb = cb;
     cb     = cb->cb_flink;

  } // end for

}

// ---------------------------------------------------------------------------
XMObject* cb_locate_object( Widget wid )
// ---------------------------------------------------------------------------
{
register struct class_bind  *cb;
register long      idx;


  idx = 0x0000007F & ((long)wid);

  cb = cbind[ idx ];

#if HASH_DEBUG
   cout<<form( "\n HASH:locate(1): locate wid=%lx ", wid );
#endif

  for(;;) {
     if( cb ) {
        if( cb->cb_widget == wid ) {
#if HASH_DEBUG
    cout<<form( "\n HASH:locate(2): found cb=%lx at idx=%d, obj=%lx ",
					  cb, idx, cb->cb_object );
#endif
            return( cb->cb_object );
	}
     } else {
	     return (NULL);
	// mod  by KS Oct 15, 1990 to fix return value
//	cout << "C++Motif binding: XMObject: Fatal class binding hash table err!";
//       exit( 1 );
     }

     cb = cb->cb_flink;

  } // end for
}


// ---------------------------------------------------------------------------
XMObject* cb_hash_dump()
// ---------------------------------------------------------------------------
{
register struct class_bind  *cb;

 // cb = cbind[ idx ];

}

// ---------------------------------------------------------------------------
XMObject* WindowToObject   (Display* d, Window w)
// ---------------------------------------------------------------------------
{
 return (cb_locate_object (XtWindowToWidget (d, w)));
}

// ---------------------------------------------------------------------------
void ManageChildren   (XMObjectList xol, Cardinal c)
// ---------------------------------------------------------------------------
{
   while( xol ) {
      XtManageChild( xol->get_widget() );
       xol++;
       if( --c == 0 ) break;
   }
}

// ---------------------------------------------------------------------------
void UnmanageChildren   (XMObjectList xol, Cardinal c)
// ---------------------------------------------------------------------------
{
   while( xol ) {
      XtUnmanageChild( xol->get_widget() );
       xol++;
       if( --c == 0 ) break;
   }
}
