/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _ch_hashing.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#include <LEDA/ch_hashing.h>

//----------------------------------------------------------------------
// hashing mit verkettung  
// Walter Zimmer
//----------------------------------------------------------------------
 



ch_hashing_el* ch_hashing::lookup(GenPtr x) const
{ 
  hash_list* L = *(get_list(x)) ;             
  list_item p = ( L ? get_list_el(x,L) : 0); 
                             //  L == 0  oder  x nicht in L  =>  p = 0

  if ( p )  return (*L)[p];
  else return 0;                    //falls x nicht in ch_hashing => return 0
}


hash_list_ptr* ch_hashing::get_list(GenPtr x) const 
{ return &( hash_table[hash_fct(x) & divisor]);}


//----------------------------------------------------------------------
// get_List_el(x,L) : gibt zeiger auf Listenelement mit key x
//                     zurueck , falls x in Liste L , sonst return 0
//----------------------------------------------------------------------

list_item ch_hashing::get_list_el(GenPtr x, hash_list* L) const
{
  for (list_item p = L->first();  p ; p = L->succ(p) ) 
    if ( cmp((*L)[p]->k,x) == 0 ) return p;

  return 0; 
}

//----------------------------------------------------------------------
// del(x) : streicht element mit key x aus ch_hashing
//----------------------------------------------------------------------

void ch_hashing::del(GenPtr x)
{
  --counter;

  hash_list* L = *( get_list(x) ); 
  list_item p = ( L ? get_list_el(x,L) : 0 ); 

  if ( p )  delete L->del(p);
}



ch_hashing_el* ch_hashing::insert(GenPtr x, GenPtr y)
{
   ++ counter ;

   hash_list_ptr* L =  get_list(x);
   hash_list_ptr l = *L;

   copy_key(x);
   copy_inf(y);

   if ( l )         // falls l != 0 => liste existiert schon 
       l->push( new ch_hashing_el(x,y) ); 
   else             //  falls l == 0 => liste muss erst angelegt werden
   {
     // neue liste anlegen und den zeiger an der stelle (*L) in die  
     // hash_table eintragen  

   (*L) = new hash_list(new ch_hashing_el(x,y));
   }

   return  (*L)->head() ;     // nicht l->head() !!!
}



void ch_hashing::print() const
{
  cout << " size = " << size() << "\n";
  cout << " table_size = " << table_size << "\n";

  hash_list_ptr* p;
  for (  p = &hash_table[table_size-1]; p >= &hash_table[0]                              ; p-- )
     if ( *p )     // falls an dieser stelle liste existiert
     {
       ch_hashing_el* x ;
       forall(x,(*(*p)) )
       {   
         print_key(x->k);
         cout << " ";
       }
       cout << "\n"; 
     }
}


void ch_hashing::init_iterator()
{ if (iterator!=0) (*iterator)->init_iterator();
  iterator = 0;
}



ch_hashing_el* ch_hashing::move_iterator()
{
  ch_hashing_el* p;

  if (!iterator)                // iterator am anfang oder wbook leer
  {
    if ( empty() ) return 0;    // falls wbook leer => return 0
    else                        // sonst existiert nichtleere liste 
    {
      // suche nach der ersten nichtleeren liste ; 
      // beginne bei hash_table[tablesize-1]

      for ( iterator = &hash_table[ table_size-1 ];                                         ( (*iterator) == 0  || (*iterator)->empty() ); --iterator )
	;
    }
  }
  else 
    if ( !( (*iterator)->next_element(p) ) )
       // falls next_element(p) 0 zurueckgibt => am ende einer liste
       //  =>  naechste nichtleere liste suchen
    {
      do
      {
	 if ( iterator == &hash_table[0] )
	       {  iterator = 0 ; return 0; }
	 else   -- iterator;
      }
      while (  !(*iterator) ||  (*iterator)->empty()   );

      // falls noch nichtleere liste existiert


    }
    else return p;  // noch nicht am ende der aktuellen liste

 // am anfang einer nichtleeren liste => init_iter + next_el(p)

 (*iterator)->init_iterator();
 (*iterator)->next_element(p);
  return p;
}



void ch_hashing::remove()
{
  clear();
  delete[table_size] hash_table; //  ??? listen loeschen ???
  hash_table = 0;
  table_size = divisor = 0;
}


void ch_hashing::clear()
{
  for (int i = table_size-1 ; i >= 0 ; --i)
     if ( hash_table[i] )    // falls liste existiert => inhalt loeschen
     {  while (! hash_table[i]->empty()) 
        { ch_hashing_el* p = hash_table[i]->pop(); 
          clear_key(p->k);
          clear_inf(p->e);
          delete p;
         }
        delete ( hash_table[i] );
        hash_table[i] = 0; 
     }
  counter = 0; 
  iterator = 0;
}


void ch_hashing::new_table_size(int Table_size)
{
   Table_size = round(Table_size);
   int Divisor = Table_size -1;
   int Counter = counter;


   hash_list_ptr* Hash_table = new hash_list_ptr[Table_size];
   for ( int i=Table_size-1 ; i >= 0 ; --i ) Hash_table[i] = 0; 


   ch_hashing_el* p;
   forall_in_ch_hashing( p , (*this) )  
   {
     hash_list_ptr* L = & ( Hash_table [ hash_fct(p->k) & Divisor ] );

     if ( *L ) 
       (*L)->push( new ch_hashing_el(p) );
     else 
       (*L) = new hash_list( new ch_hashing_el(p));
   } 
   

   remove();

   counter = Counter;
   hash_table = Hash_table;
   table_size = Table_size;
   divisor = Divisor;
   // iterator durch remove() auf 0 gesetzt
}


ch_hashing::ch_hashing(int Table_size)
{
  table_size = round(Table_size);
  divisor = table_size-1;
  hash_table = new hash_list_ptr[table_size];
  for ( register int i = table_size-1; i >= 0 ; --i )
	  hash_table[i] = 0;
  counter = 0;
  iterator = 0;
}


//----------------------------------------------------------------------
// runded auf die naechste zweierpotenz auf
//----------------------------------------------------------------------

int ch_hashing::round(int a) const
{
  for (int  b = 1 ; a > 0 ; a >>= 1)   b <<= 1;
  return b-1;
}

