#include <LEDA/dictionary.h>
#include <LEDA/skiplist.h>
#include <LEDA/ab_tree.h>
#include <LEDA/bb_tree.h>
#include <LEDA/rb_tree.h>
#include <LEDA/ch_hashing.h>
#include <LEDA/dp_hashing.h>

#define DIC_TEST(type,D,P)\
  type D;\
  cout << string("%10s:","type");\
  cout.flush();\
  for(i=0; i<N; i++)  D.insert(P(RAND[i]),0);\
  cout << string("%10.2f",used_time(T));\
  cout.flush();\
\
  for(i=0; i<N; i++)  D.lookup(P(RAND[i]));\
  cout << string("%10.2f",used_time(T));\
  cout.flush();\
\
  for(i=0; i<N; i++)  D.del(P(RAND[i]));\
  cout << string("%10.2f",used_time(T));\
  newline;\

declare2(dictionary,int,int)

typedef dictionary(int,int) Dictionary;

void main()

{
  int  N = read_int("# keys = ");
  int* RAND = new int[N];
  int  i;

  init_random();

  for(i=0; i<N; i++) RAND[i] = random(0,MAXINT-1);

  float T = used_time();


  newline;
  cout << "                insert    lookup    delete\n";
  newline;

  DIC_TEST(Dictionary,dic,int)
  DIC_TEST(rb_tree,RB_TREE,GenPtr)
  DIC_TEST(skiplist,SKIP,GenPtr)
  DIC_TEST(dphash,DPH,GenPtr)
  DIC_TEST(bb_tree,BB_TREE,GenPtr)
  DIC_TEST(ab_tree,AB_TREE,GenPtr)
}
