/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  int_set.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef INTSETH
#define INTSETH

//------------------------------------------------------------------------------
/* int_set: integer sets implemented by bit vectors                           */
//------------------------------------------------------------------------------

#include <LEDA/basic.h>

class int_set {

char*  V;
int size;
int low;
char mask[8];

public:

 int_set(int n); 
 int_set(int,int); 
 int_set(const int_set&);
~int_set() { delete V; } 


void clear();
void insert(int);
void del(int);

int  member(int) const;

int_set& join(const int_set&);
int_set& intersect(const int_set&);
int_set& complement();

int_set& operator=(const int_set&);

int_set  operator|(const int_set&);
int_set  operator&(const int_set&);
int_set  operator~();

};

#endif
