/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  ch_hashing.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/





//------------------------------------------------------------------------------
// Hashing with Chaining
// 
// Walter Zimmer   (1989)
//------------------------------------------------------------------------------

#ifndef CHHASHINGH
#define CHHASHINGH

#include <LEDA/basic.h>
#include <LEDA/list.h>
 
#define NOTEST

#ifdef TEST
#define TRACE(x)  cout << form x
#define TRACE2(x,ebene)  if ( debug >= (ebene) ) cout << form  x
#define TRACE_FUNC(x) x
// extern int debug ; muss im testprogramm definiert werden , falls
// Trace2(x,ebene) benutzt wird
#else 
#define TRACE(x) 
#define TRACE2(x,ebene) 
#define TRACE_FUNC(x) 
#endif


//--------------------------------------------------------------------
// some declarations and type definitions
//--------------------------------------------------------------------
 

class ch_hashing_el {
  GenPtr k;
  GenPtr e;
  friend class ch_hashing;

  public:

  ch_hashing_el(ch_hashing_el* p)     
  { 
    k = p->k; 
    e = p->e; 
   }

  ch_hashing_el(GenPtr K = 0, GenPtr E = 0) 
  { 
    k = K; 
    e = E; 
   }

  LEDA_MEMORY(ch_hashing_el)

};

typedef ch_hashing_el* list2_el;
declare(list,list2_el);
typedef list(list2_el) hash_list;
typedef hash_list* hash_list_ptr;

const int default_hash_tablesize = 1000;

//--------------------------------------------------------------------
// class ch_hashing
//--------------------------------------------------------------------

class ch_hashing {
  
   hash_list_ptr* hash_table;
   int table_size;           
   int divisor;   // divisor = 2^n-1 = 00..0011.11  
                  // => statt " modulo table_size " einfach " & divisor"
   hash_list_ptr* iterator;
   int counter;

   int round(int) const;
   hash_list_ptr* get_list(GenPtr) const;
   list_item      get_list_el(GenPtr,hash_list*) const;

   virtual int hash_fct(GenPtr x)     const  { return int(x); }
   virtual int cmp(GenPtr x, GenPtr y) const { return int(x) - int(y); }
   virtual void clear_key(GenPtr& x)  const { x=0; }
   virtual void clear_inf(GenPtr& x)  const { x=0; }
   virtual void copy_key(GenPtr& x)   const { x=x; }
   virtual void copy_inf(GenPtr& x)   const { x=x; }
   virtual void print_key(GenPtr& x)  const { cout << int(x); }

   public:

   ch_hashing_el* lookup(GenPtr) const;
   ch_hashing_el* insert(GenPtr,GenPtr);

   void del(GenPtr);

   bool member(GenPtr x)   const  { return ( lookup(x) ? true : false ); } 

   GenPtr& access(GenPtr);

   GenPtr  key(ch_hashing_el* p)  const { return p->k; }
   GenPtr  inf(ch_hashing_el* p)  const { return p->e; }
   GenPtr& info(ch_hashing_el* p)       { return p->e; }

   bool change_obj(GenPtr x, GenPtr y);
   void change_inf( ch_hashing_el* p , GenPtr y) { copy_inf(p->e = y) ; }

   bool empty()  const { return counter ? false : true ; } 
   int   size()  const { return counter; } 

   int  tablesize() const { return table_size ; }

   void print() const ;

   float average_list_length()  const { return float(counter) / table_size ; }

   void init_iterator();

   ch_hashing_el* move_iterator();

   void new_table_size(int); 


   void clear();
   void remove();

   ch_hashing(int=default_hash_tablesize);

   ~ch_hashing() { remove(); }    //  neben clear auch remove implem.

};  // end of class ch_hashing



#define forall_in_ch_hashing(k,t)\
for( (t).init_iterator() ; (k)=(t).move_iterator() ; )



#endif CHHASHINGH
