//
//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// This file  contains  useful definitions,  macros, and constants used through
// out most header and source files.
//

#ifndef MISCELANEOUSH				// If no miscelaneous header
#define MISCELANEOUSH

#ifndef DEFSH
#include <defs.h>				// Include the defs header
#endif

#if defined(MSDOS) && !defined(DOS)		// For IBM or MS compilers
#define DOS
#endif

#ifndef INVALID					// Define INVALID for curpos
#define INVALID (-1)
#endif

#ifndef END_OF_STRING				// If END_OF_STRING not defined
#define END_OF_STRING (0)
#endif

#ifndef NEWLINE					// If Newline char not defined
#define NEWLINE '\n'
#endif

#ifndef SENSITIVE				// If case flags not defined
#define SENSITIVE TRUE
#define INSENSITIVE FALSE
#endif

#ifndef BITSPERBYTE				// Machine bits per byte macros
#define BITSPERBYTE 8
#define BITS(type) (BITSPERBYTE * (int)sizeof(type))
#define MINSHORT  ((short)(1 << BITS(short) - 1))
#define MININT  (1 << BITS(int) - 1)
#define MINLONG  (1L << BITS(long) - 1)
#define MAXSHORT ((short)~MINSHORT)
#define MAXINT  (~MININT)
#define MAXLONG (~MINLONG)
#endif

#ifndef NUMBER_STATES
#define NUMBER_STATES
enum N_status { N_OK, N_MINUS_INFINITY, N_PLUS_INFINITY, N_OVERFLOW,
		N_UNDERFLOW, N_NO_CONVERSION, N_DIVIDE_BY_ZERO };
#endif

#ifndef MAXDOUBLE
#if pdp11 || vax				// Vaxen do it their own way...
#define MAXDOUBLE	1.701411834604692293e+38
#define MAXFLOAT	((float)1.701411733192644299e+38)
/* The following is kludged because the PDP-11 compilers botch the simple form.
   The kludge causes the constant to be computed at run-time on the PDP-11,
   even though it is still "folded" at compile-time on the VAX. */
#define MINDOUBLE	(0.01 * 2.938735877055718770e-37)
#define MINFLOAT	((float)MINDOUBLE)
#define _IEEE		0
#define _DEXPLEN	8
#define _HIDDENBIT	1
#define DMINEXP	(-DMAXEXP)
#define FMINEXP	(-FMAXEXP)
#else						// IEEE floating point
#define MAXDOUBLE	1.79769313486231470e+308
#define MAXFLOAT	((float)3.40282346638528860e+38)
#define MINDOUBLE	4.94065645841246544e-324
#define MINFLOAT	((float)1.40129846432481707e-45)
#define	_IEEE		1
#define _DEXPLEN	11
#define _HIDDENBIT	1
#define DMINEXP	(-(DMAXEXP + DSIGNIF - _HIDDENBIT - 3))
#define FMINEXP	(-(FMAXEXP + FSIGNIF - _HIDDENBIT - 3))
#endif
#endif

#ifndef ABS
#define ABS(x) ((x >= 0) ? (x) : (-x))
#endif

// even --  Determine if long integer is odd of even
// Input:   long integer
// Output:  Boolean TRUE/FALSE

inline Boolean even (long n) {
  return ((n & 1) ? FALSE : TRUE);
}

// odd --  Determine if long integer is odd of even
// Input:  long integer
// Output: Boolean TRUE/FALSE

inline Boolean odd (long n) {
  return ((n & 1) ? TRUE : FALSE);
}

// The "#pragma defmacro" is a COOL extension to the standard  ANSI C processor
// that allows  a programmer to  define macro  extensions to the  language. All
// COOL  macros   have  been  incorporated  into  the preprocessor   itself  to
// facilitate extra speed and efficiency. User defined  extensions are searched
// for on the include file path.

#pragma defmacro MACRO "macro" delimiter=} recursive
#pragma defmacro template "template" delimiter=}
#pragma defmacro DECLARE "declare" delimiter=> recursive lines
#pragma defmacro IMPLEMENT "implement" delimiter=> recursive lines

#endif MISCELANEOUSH				// End #ifdef
