//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: LGO 01/05/90 -- Split into seperate files
// Updated: DLS 03/22/91 -- New lite version
//
// strnyank -- the equivalent of doing a strndup and a strnremove.
// Returns a char* to the copy of zero-end elements of the given string.
// Modifies the given string by removing the zero-end elements.
//

#include <cool/char.h>	// Include char* specification header file


char* strnyank (char* s, long end) {
  int len = strlen(s);
  if (end>len) end=len;
  long mark = end;
  char* ret = (char*) new char[end+1];
  if (end < 0) return(NULL);
  for(int ind=0; ind <= len; ind++) {
    if (ind<mark) ret[ind]=s[ind];
    s[ind]=s[end];
    end++;
  }
  ret[mark]=END_OF_STRING;
  return(ret);
}
