//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/String.h>
#include <cool/Range.h>
#include <test.h>

DECLARE Range<int,2,8>;
IMPLEMENT Range<int,2,8>;
DECLARE Range<double,2.5,8.8>;
IMPLEMENT Range<double,2.5,8.8>;
DECLARE Range<char*,"D", "K">;
IMPLEMENT Range<char*, "D", "K">;


extern int my_compare (const charP& s1, const charP& s2) {
  return (strcmp (s1, s2));
}


void test_int () {
  Range<int,2,8> r1;
  TEST ("Range<int,2,8> r1", 1, 1);
  TEST ("r1.low()==2", r1.low(), 2);
  TEST ("r1.high()==8", r1.high(), 8);
  TEST ("r1.set(4)", (r1.set(4), int(r1)), 4);
  TEST ("r1()", int(r1), 4);
  int i;
  TEST ("int i = 2+r1", (i=2+r1,i), 6);
  Range<int,2,8> r2(r1);
  TEST ("Range<int,2,8> r2(r1)", int(r2), 4);
}


void test_double () {
  Range<double,2.5,8.8> r1;
  TEST ("Range<double,2.5,8.8> r1", 1, 1);
  TEST ("r1.low()==2.5", r1.low(), 2.5);
  TEST ("r1.high()==8.8", r1.high(), 8.8);
  TEST ("r1.set(4.3)", (r1.set(4.3), double(r1)), 4.3);
  TEST ("r1()", double(r1), 4.3);
  double d;
  TEST ("double d = 2.8+r1", (d=2.8+r1,d), 7.1);
  Range<double,2.5,8.8> r2(r1);
  TEST ("Range<double,2.5,8.8> r2(r1)", double(r2), 4.3);
}


void test_charP () {
  Range<charP,"D","K"> r1;
  TEST ("Range<char*,\"D\",\"K\"> r1", 1, 1);
  TEST ("r1.set_compare (&my_compare)", (r1.set_compare(&my_compare),1),1); 
  TEST ("r1.low()==\"D\"", strcmp (r1.low(),"D"), 0);
  TEST ("r1.high()==\"K\"", strcmp (r1.high(),"K"), 0);
  TEST ("r1.set(\"EFG\")", (r1.set("EFG"), strcmp ((char*)r1, "EFG")), 0);
  TEST ("r1()", strcmp ((char*)r1, "EFG"), 0);
  String s1 (r1);
  TEST ("String s1(r1)", strcmp (s1,"EFG"), 0);
  Range<char*,"D","K"> r2(r1);
  TEST ("Range<char*,\"D\",\"K\"> r2(r1)", strcmp ((char*)r2, "EFG"), 0);
}


int main () {
  START("Range");
  test_int();
  test_double();
  test_charP();
  SUMMARY();
  return 0;
}
