//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/String.h>
#include <cool/Package.h>
#include <cool/Properties.h>
#include <test.h>

symbol_package(STEST, "test_sym.p")
enumeration_package(enum, "test_enum.p")
text_package(text, "test_text.p")

DEF_STEST(sym2, String, new String("Greetings!"))
DEF_STEST_PROPERTY(sym2, STEST(value-type), Symbol, STEST(String))

//-------------------------------------------------------------
// Test Symbol

void test_Symbol () {
  Generic* value;
  Symbol* sym1 = STEST(sym1);
  TEST("Value", *(String*) STEST(sym2)->value(), "Greetings!");
  TEST("Property", STEST(sym2)->get(STEST(value-type), value), TRUE);
  TEST("Property value", ((Symbol*) value), STEST(String));
  sym1->put(STEST(prop1), (Generic*) "test Char*");
  TEST("Put/get", sym1->get(STEST(prop1), value), TRUE);
  TEST("Get value", strcmp((char*) value, "test Char*"), 0);
  TEST("Plist", sym1->plist()->length(), 1);
  TEST("Remove", sym1->remove(STEST(prop1)), TRUE);
  TEST("Plist after remove", sym1->plist()->length(), 0);
  TEST("Get after remove", sym1->get(STEST(prop1), value), FALSE);
  TEST("Get if not in plist", STEST(sym2)->get(STEST(prop2), value), FALSE);
  TEST("Enumeration 0", enum(First), 0);
  TEST("Enumeration 1", enum(Second), 1);
  TEST("Enumeration 2", enum(Third), 2);
  TEST(text("Greetings!, This is a test: \"1\" 2 3"),
       strcmp (text("Greetings!, This is a test: \"1\" 2 3"),
	       "Greetings!, This is a test: \"1\" 2 3"), 0);
  TEST(text("Convert to western"),
       set_text_language(SYM(western), &text_entries[0]), 1);
  TEST(text("Greetings!, This is a test: \"1\" 2 3"),
       strcmp (text("Greetings!, This is a test: \"1\" 2 3"),
	       "Howdy!, What ya'all up to?"), 0);
  TEST("Convert to program",
       set_text_language(NULL, &text_entries[0]), 0);
  TEST(text("Greetings!, This is a test: \"1\" 2 3"),
       strcmp (text("Greetings!, This is a test: \"1\" 2 3"),
	       "Greetings!, This is a test: \"1\" 2 3"), 0);
  TEST ("Describe", TRUE, TRUE);
  sym1->describe(cout);
}

int main (void) {
  START("Symbol");
  test_Symbol();
  SUMMARY();
  return 0;
}
