//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/22/89 -- Initial design and implementation
// Updated: MBN 09/16/89 -- Added conditional exception handling
//

#include <cool/Package.h>

// operator<< -- Overload the output operator to provide a crude print
//               capability for Package objects
// Input:        ostream reference, Package reference
// Output:       Reference to ostream

#ifdef __cplusplus
ostream& operator<< (ostream& os, const Package& p) {
  long buckets = p.get_bucket_count();
  if (buckets <= 0)
    os << "Package with no symbols";		// so indicate state
  else {
    char* seperator = " ";
    os << "Package with " << p.length() << " symbols:";
    for (long i = 0; i < buckets; i++) { // For each bucket
      for (int j = 0; j < p.get_count_in_bucket(i); j++) {
	os << seperator; seperator = ",";
	os << p.Hash_Table<char*, Symbol*>::table[i].data[j].value;
      }
    }
  }
  return os;					// Return refererence to stream
}
#else
// cfront 1.2 won't give us access to protected base class slots
ostream& operator<< (ostream& os, const Package& p) {
  p.reset();					// Startint at first entry
  if (p.next()) {				// If there is a valid entry
    os << "Package with " << p.length() << " symbols: " << p.value(); // Print
    while (p.next())				// While remaining entries
      os << ", " << p.value();			// Output all values
  }
  else						// Else no entries in package
    os << "Package with no symbols";		// so indicate state
  return os;					// Return refererence to stream
}
#endif
