//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/19/89 -- Initial design and implementation
// Updated: MBN 09/18/89 -- Changed package name to uppercase

#include <cool/Generic.h>

#if GENERIC_TYPECHECK

Boolean Generic::map_over_slots (Slot_Mapper procedure, void* rock)
//
// Call procedure on every slot in the object with parameters:
//     (this, char* SlotName, void* ValuePointer, Symbol* type, rock)
// Returns true if all procedure calls return true.
//
//{ return // quit returning false if any procedure returns false
//    Base_Class::map_over_slots(procedure rock) // Inherited slots get done first.
// || (procedure)(this, "Slot1", &slot1, SYM(int), rock)   // number
// || (procedure)(this, "Slot2", &slot2, SYM(char*), rock) // string
//    ...
// || (procedure)(this, "Slotn", &slotn, slotn.type_of(), rock);  // Generic
// }
{
  Slot_Mapper ignore1 = procedure;	// eliminate unused parameter
  void* ignore2 = rock;			// compiler warnings
  return FALSE;				// no slots
}

#endif
