//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate file.
// Updated: MJF 02/22/90 -- Changed to use exception::match().

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// **********************************************************************
// Member function for the Excp_Handler class
// **********************************************************************

// Boolean invoke_handler(Exception*)  -- returns TRUE if Excp Handler function
//                                        is invoked on specified Exception;
//                                        otherwise returns FALSE.
//
// Input:   An exception object pointer
// Output:  TRUE or FALSE

Boolean Excp_Handler::invoke_handler(Exception* excp) {
  if (excp->match(this->excp_types) && this->eh_func != NULL) {
    (*this->eh_func)(excp);
    excp->handled(TRUE);
    return TRUE;
  } else return FALSE;
}
