//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate file.
// Updated: MJF 02/23/90 -- Changed to use array of exceptions slot.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// **********************************************************************
// Constructor for the Excp_Handler class
// **********************************************************************

// Excp_Handler(Excp_Handler_Function, Excp_Type) -- an Excp Handler constructor
//                                                   which initializes with the
//                                                   specified Exception type
//                                                   and Excp Handler function.
//
// Input:   An Exception Handler function and an exception type.
// Output:  None.

Excp_Handler::Excp_Handler(Excp_Handler_Function ehf, Excp_Type et) {
  this->eh_func = ehf;
  this->excp_types = (Excp_Type*) new Excp_Type[2];
  this->excp_types[0] = et;
  this->excp_types[1] = NULL;
  this->next_handler = this->top_handler;
  this->top_handler = this;
}
