//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MJF 02/22/90 -- New constructor for specifying multiple group names.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#ifndef STDARGH			// If variable args not defined
# if defined(M_XENIX)
#  include <stdarg.hxx>
# else
#  include <stdarg.h>
# endif
#define STDARGH
#endif

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// ************************************************************************
// Constructor for Exception class
// ************************************************************************

// Exception(int, Excp_Type, ...) - an Exception constructor which initializes 
//                                  the group names with one or more
//                                  exception types.
//
// Input:   One or more exception types.
// Output:  None.

Exception::Exception(int n, Excp_Type etype, ...) {
  this->excp_handled = FALSE;
  this->msg_prefix = this->format_msg = NULL;
  if (n > 0) {
    this->group_names = (Excp_Type*) new Excp_Type[n+1];
    this->group_names[0] = etype;
    va_list excp_args;
    va_start(excp_args, etype);
    for (int i = 1; i < n; i++) {
      this->group_names[i] = (Excp_Type) va_arg(excp_args, Excp_Type);
    }
    this->group_names[n] = NULL;  // null terminated array
  } else this->group_names = NULL;
}


/* another way to do this is use function get_excps

extern Excp_Type* get_excps(int n, va_list excp_args);

Exception::Exception(int n, Excp_Type etype, ...) {
  this->excp_handled = FALSE;
  this->msg_prefix = this->format_msg = NULL;
  if (n > 0) {
    va_list excp_args;
    va_start (excp_args, n);
    this->group_names = get_excps(n, excp_args);
  } else this->group_names = NULL;
}

*/


