//$XWindowSystem,XEvtHandler$
#include "XWindowSystem.h"

#include "XWindowPort.h"
#include "XFont.h"
#include "XBitmap.h"
#include "XClipBoard.h"

#include "../String.h"
#include "../Error.h"

XDisplay *display;
XWindow rootwin, awin;
int screen;
XContext context;
int xfd;
XClipBoard *xclip;
XColormap cmap;
int colors[30];
static char *cnames[]= {
    "",
    "white",                // 100 %
    "black",                // 0 %
    "#202020",              // 87 %
    "#404040",              // 75 %
    "#606060",              // 60 %
    "#808080",              // 50 %
    "#a0a0a0",              // 40 %
    "#c0c0c0",              // 25 %
    "#e0e0e0",              // 12 %
    
    "yellow",
    "spring green",
    "yellow green",
    "green",
    "blue",
    "blue violet",
    "violet red",
    "red",
    "orange red",
    "orange",
    
    "cyan",
    "magenta",
    "pink",
    "turquoise",
    "gold",
    "tan",
    0
};

//---- XEvtHandler -------------------------------------------------------------

class XEvtHandler : public SysEvtHandler {
public:
    XEvtHandler(int xfd) : (xfd)
	{ }
    void Notify(SysEventCodes, int);
    bool HasInterest();
};

bool XEvtHandler::HasInterest()
{
    XFlush(display);
    return ! ShouldRemove();
}

void XEvtHandler::Notify(SysEventCodes, int)
{
    XEvent ev;
    XWindowPort *port;
    Token t;
    
    XPending(display);
    do {
	XNextEvent(display, ev);
	port= 0;
	if (XFindContext(display, ev.xany.window, context, port) == 0)
	    if (port && port->MapEvent(&t, &ev))
		port->Send(&t);
    } while (XQLength(display) > 0);
}

//---- XWindowSystem -----------------------------------------------------------

WindowSystem *NewXWindowSystem()
{
    WindowSystem *s= new XWindowSystem();
    if (s->Open())
	return s;
    delete s;
    return 0;
}

XWindowSystem::XWindowSystem() : ("X11R2")
{
}

extern char *LibName;

bool XWindowSystem::Open()
{
    int i, npaths;
    char pathname[100], **newpaths, **paths;
    XColor exact_def;
    
    if ((display= XOpenDisplay(0)) == NULL)
	return FALSE;
	
    context= XUniqueContext();
    
    paths= XGetFontPath(display, npaths);
    sprintf(pathname, "%s/xfonts/", LibName);
    for (i= 0; i < npaths; i++)
	if (strcmp(paths[i], pathname) == 0)
	    break;
    if (i >= npaths) {  // not found
	newpaths= (char**) new ObjPtr[npaths+1];
	for (i= 0; i < npaths; i++)
	    newpaths[i]= paths[i];
	newpaths[i]= pathname;
	XSetFontPath(display, newpaths, npaths+1);
	delete newpaths;
    }
    
    screen= XDefaultScreen(display);
    rootwin= XRootWindow(display, screen);
    
    if (! WindowSystem::Open())
	return FALSE;
	
    xfd= display->fd;
    gSystem->AddFileInputHandler(new XEvtHandler(display->fd));

    XSelectInput(display, rootwin, PropertyChangeMask);

    
    if (XDefaultDepth(display, screen) > 1) {
	cmap= XDefaultColormap(display, screen);
	
	for (i= 1; cnames[i]; i++) {
	    colors[i]= XWhitePixel(display, screen);
	    if (! XParseColor(display, cmap, cnames[i], &exact_def)) {
		Warning("XWindowSystem::Open", "color name %s not in database", cnames[i]);
		continue;
	    }
	    if (!XAllocColor(display, cmap, &exact_def)) {
		Warning("XWindowSystem::Open", "all colorcells allocated");
		continue;
	    }
	    colors[i]= exact_def.pixel;
	}
    }
    return TRUE;
}

void XWindowSystem::Close()
{
    XSetFontPath(display, 0, 0);
    XCloseDisplay(display);
}

void XWindowSystem::MakeWindow(WindowPort **wp, InpHandlerFun ihf,
			    void *priv1, void *priv2, bool overlay, bool block)
{
    *wp= new XWindowPort(ihf, priv1, priv2, overlay, block);
}

FontManager *XWindowSystem::MakeFontManager(char *name)
{
    return new XFontManager(name);
}

void XWindowSystem::MakeBitmap(Bitmap **bp, Point sz, short *data)
{
    *bp= new XBitmap(sz, data);
}

void XWindowSystem::MakeBitmap(Bitmap **bp, const char *name)
{
}

void XWindowSystem::graphicDelay(unsigned int duration)
{
    XSync(display, XFalse);
    Wait(duration);
}

Rectangle XWindowSystem::GetScreenRect()
{
    return Rectangle(0, 0, XDisplayWidth(display, screen),
				    XDisplayHeight(display, screen));
}

bool XWindowSystem::interrupted()
{
    XEvent ev;
    if (XCheckTypedEvent(display, KeyPress, ev))
	if (((XKeyEvent*)&ev)->keycode == 8) // SUN L1 function key -> ET++ interrupt
	    return TRUE;
    return FALSE;
}

ClipBoard *XWindowSystem::MakeClipboard()
{
    return xclip= new XClipBoard;
}
