//$XServerFont,XFontManager$
#include "XFont.h"
#include "XWindowSystem.h"
#include "../String.h"
#include "../Error.h"

XServerFont::XServerFont(char *fontname, GrFont fid, int ps, GrFace fc)
{
    family= (byte) fid;
    size= (byte) ps;
    face= (byte) fc;
    
    xfid= 0;
    fname= strsave(fontname);
}

bool XServerFont::Loaded()
{
    return xfid != 0;
}

bool XServerFont::LoadFont()
{
    register XFontStruct *xFont;
    register int i, j;
    char *fn, *otherfont= Fixed() ? "fixed" : "6x10";
    register byte w;
    
    fn= fname;
    if ((xFont= XLoadQueryFont(display, fn)) == 0) {
	Warning("XServerFont::LoadFont", "can't load font %s; trying %s", fn, otherfont);
	fn= otherfont;
	if ((xFont= XLoadQueryFont(display, fn)) == 0) {
	    Warning("XServerFont::LoadFont", "can't load font %s; giving up", fn);
	    return TRUE;
	}
    }
	
    ht= xFont->max_bounds.ascent;
    bs= xFont->max_bounds.descent;
    ils= ht + bs + 3;
    
    if (xFont->per_char)
	w= (byte) xFont->per_char[xFont->default_char].width;
    else
	w= xFont->max_bounds.width;

    for (i= 0; i < 256; i++)
	cw[i]= w;
    
    if (xFont->per_char) {
	if (xFont->min_byte1 == NULL && xFont->max_byte1 == NULL)
	    for (i= xFont->min_char_or_byte2, j= 0; i <= xFont->max_char_or_byte2; i++, j++)
		cw[i]= (byte) xFont->per_char[j].width;
	else
	    cerr << "Et++ can't handle two-byte fonts\n";
    }
    xfid= xFont->fid;
    XFreeFontInfo(&fn, xFont, 1);
    return FALSE;
}

XServerFont::~XServerFont()
{
    SafeDelete(fname);
    if (xfid)
	XUnloadFont(display, xfid);
}

Font* XFontManager::MakeFont(char *vname, GrFont fid, int ps, GrFace fc)
{
    return new XServerFont(vname, fid, ps, fc);
}
