//$System,SysEvtHandler,Directory,PttyConnection,IntHandler$
#include "System.h"
#include "ObjList.h"
#include "FileType.h"
#include "ObjectTable.h"

#include "String.h"
#include "Error.h"
#include "Class.h"

#include <signal.h>

char    gBackspace;
char    gRubout;
char    *LibName;
bool    gAbort;
System  *gSystem;

static bool inRemove= FALSE;

extern void exit(int);
extern int abort();

//---- class SysEvtHandler ---------------------------------------

AbstractMetaImpl(SysEvtHandler, I_I(resourceId));

SysEvtHandler::SysEvtHandler(int id)
{
    remove= FALSE;
    resourceId= id;
}

SysEvtHandler::~SysEvtHandler()
{
    if (!inRemove) {
	Remove();
	this= 0;
    }
}

int SysEvtHandler::GetResourceId()
{
    return resourceId;
}

void SysEvtHandler::SetResourceId(int id)
{
    resourceId= id;
}

void SysEvtHandler::Notify(SysEventCodes, int)
{
}

bool SysEvtHandler::HasInterest()
{
    //return ! ShouldRemove();
    return TRUE;
}

bool SysEvtHandler::ShouldRemove()
{
    return remove;
}

bool SysEvtHandler::IsEqual(Object *op)
{
    return resourceId == ((SysEvtHandler*)op)->resourceId;
}

void SysEvtHandler::Remove()
{
    remove= TRUE;
    if (gSystem)
	gSystem->anyremoved= TRUE;
}

//---- IntHandler --------------------------------------------------------------

class IntHandler : public SysEvtHandler {
public:
    IntHandler() : (SIGINT)
	{ }
    void Notify(SysEventCodes, int);
};

void IntHandler::Notify(SysEventCodes, int)
{
    if (gSystem)
	gSystem->ExitControl();
}

//---- PttyConnection ----------------------------------------------------------

PttyConnection::PttyConnection()
{
}

PttyConnection::~PttyConnection()
{
}

FILE *PttyConnection::GetFile()
{
    return 0;
}

int PttyConnection::GetPid()
{
    return -1;
}

int PttyConnection::GetFileNo()
{
    return -1;
}

bool PttyConnection::SubmitToSlave(char *, int)
{
    return FALSE;
}

int PttyConnection::Read(char *, int)
{
    return -1;
}

int PttyConnection::GetMode()
{
    return 0;
}

void PttyConnection::KillChild()
{
}

void PttyConnection::CleanupPtty()
{
}

bool PttyConnection::Echo()
{
    return FALSE;
}

bool PttyConnection::RawOrCBreak()
{
    return FALSE;
}

void PttyConnection::BecomeConsole()
{
}

void PttyConnection::SetSize(int,int)
{
}

void PttyConnection::GetPttyChars(PttyChars *)
{
}

//---- System ------------------------------------------------------------------

System::System(char *name)
{
    osid= name;
}

bool System::Init()
{
    if ((LibName= getenv("ET_DIR")) == 0)
	LibName= "/home/sebastian/et";

    fileInputHandler    = new ObjList;
    fileOutputHandler   = new ObjList;
    zombieHandler       = new ObjList;
    signalHandler       = new ObjList;
    asyncSignalHandler  = new ObjList;
    timeoutHandler      = new ObjList;
    cleanupList         = new ObjList;
    ObjectTableAddRoots(fileInputHandler, fileOutputHandler, zombieHandler,
			signalHandler, asyncSignalHandler, timeoutHandler,
			cleanupList, 0);
    GetTtyChars(gBackspace, gRubout);

    gSystem->AddSignalHandler(new IntHandler);

    return FALSE;
}

static void FreeDelete(ObjList *ol)
{
    if (ol) {
	// ol->FreeAll();
	SafeDelete(ol);
    }
}

System::~System()
{
    FreeDelete(fileInputHandler);
    FreeDelete(fileOutputHandler);
    FreeDelete(zombieHandler);
    FreeDelete(signalHandler);
    FreeDelete(asyncSignalHandler);
    FreeDelete(timeoutHandler);
    FreeDelete(cleanupList);
}

void System::GetTtyChars(char &backspace, char &rubout)
{
    backspace= '\b';
    rubout= 0x7f;
}

void System::exit(int code, bool mode= TRUE)
{    
    if (mode)
	::exit(code);
    ::_exit(code);
}

void System::Control()
{
    done= FALSE;
    while (! done) {
	InnerLoop();
	if (anyremoved)
	    Remove();
    }
}

void System::InnerLoop()
{
    AbstractMethod("InnerLoop");
}

Directory *System::MakeDirectory(char *name)
{
    return new Directory(name);
}

class ClipBoard *System::MakeClipboard()
{
    return 0;
}

FileType *System::GetFileType(char *path)
{
    return new FileType(path);
}

bool System::AccessPathName(char*, int)
{
    return FALSE;
}

bool System::ExpandPathName(char*, int)
{
    return FALSE;
}
    
bool System::ChangeDirectory(char *)
{
    return FALSE;
}
    
char *System::WorkingDirectory()
{
    return 0;
}

void System::wait(unsigned int)
{
}

static void RemoveDeleted(ObjList *ol)
{
    if (ol->Size() <= 0)
	return;
    Iter next(ol);
    register SysEvtHandler *eh;
    
    while (eh= (SysEvtHandler*) next())
	if (eh->ShouldRemove())
	    delete ol->RemovePtr(eh);
}

void System::Remove()
{
    inRemove= TRUE;
    RemoveDeleted(fileInputHandler);
    RemoveDeleted(fileOutputHandler);
    RemoveDeleted(zombieHandler);
    RemoveDeleted(signalHandler);
    RemoveDeleted(asyncSignalHandler);
    RemoveDeleted(timeoutHandler);
    cleanupList->FreeAll();
    cleanupList->Empty(cCollectionInitCap);
    inRemove= anyremoved= FALSE;
}

SysEvtHandler *System::AddFileInputHandler(SysEvtHandler *re)
{
    SysEvtHandler *old= 0;
    if (fileInputHandler->FindPtr(re))
	old= (SysEvtHandler *)fileInputHandler->RemovePtr(old);
    fileInputHandler->Add(re);
    return old;
}

SysEvtHandler *System::AddFileOutputHandler(SysEvtHandler *re)
{
    SysEvtHandler *old= 0;
    if (fileOutputHandler->FindPtr(re))
	old= (SysEvtHandler*) fileOutputHandler->RemovePtr(re);
    fileOutputHandler->Add(re);
    return old;
}

SysEvtHandler *System::AddZombieHandler(SysEvtHandler *re)
{
    zombieHandler->Add(re);
    return re;
}

SysEvtHandler *System::AddSignalHandler(SysEvtHandler *re, bool sync)
{
    ObjList *shl= sync ? signalHandler : asyncSignalHandler;
    SysEvtHandler *fsh, *seh= new SysEvtHandler(re->GetResourceId());
    fsh= (SysEvtHandler*) shl->Remove(seh);
    shl->Add(re);
    delete seh;
    return fsh;
}

SysEvtHandler *System::AddTimeoutHandler(SysEvtHandler *re)
{
    timeoutHandler->Add(re);
    return re;
}

void System::AddCleanupObject(Object *op)
{
    cleanupList->Add(op);
    if (gSystem)
	gSystem->anyremoved= TRUE;
}

void System::abort(int)
{
    if (gAbort)
	::abort();
    stacktrace(0, TRUE);
}

PttyConnection* System::MakePttyConnection(char *, char **)
{
    return 0;
}

//---- environment manipulation ------------------------------------------------

char *System::getenv(char*)
{
    return 0;
}

void System::Setenv(char*, char*)
{
}

void System::Unsetenv(char *)
{
}

//---- stack trace -------------------------------------------------------------

void System::stacktrace(int, bool abortafter)
{
    if (abortafter)
	::abort();
}

//---- Directory ---------------------------------------------------------------

Directory::~Directory()
{
}

char *Directory::operator()()
{
    return 0;
}
