#include "sungr.h"
#include <pixrect/pixrect_hs.h>
#include <pixrect/pixrect.h>
#include <pixrect/memvar.h>

struct pixrect *sunbitmap_load(filename)
char *filename;
{
    extern struct pixrect *pr_load();
    struct pixrect *pr= 0;
    FILE *infp;
    
    if ((infp= fopen(filename, "r")) == 0)
	return 0;
    if (pr= pr_load(infp, 0))
	fclose(infp);
    return pr;
}

extern void sunbitmap_free(pr)
struct pixrect *pr;
{
    pr_destroy(pr);
}

struct pixrect *sunbitmap_create(sz, im)
struct point sz;
short *im;
{
    return mem_point(sz.p_x, sz.p_y, 1, im);
}

short *sunbitmap_image(pr)
struct pixrect *pr;
{
    return mpr_d(pr)->md_image;
}

struct point sunbitmap_size(pr)
struct pixrect *pr;
{
    struct point p;
    p.p_x= pr->pr_size.x;
    p.p_y= pr->pr_size.y;
    return p;
}
