//$SunWindowPort,SunEvtHandler$
#include "SunWindowPort.h"
#include "../String.h"

SunWindowPort *overlayport;

//---- SunEvtHandler -----------------------------------------------------------

class SunEvtHandler : public SysEvtHandler {
    class SunWindowPort *port;
public:
    SunEvtHandler(SunWindowPort *sp, int rfd) : (rfd)
	{ port= sp; }
    ~SunEvtHandler();
    void Notify(SysEventCodes, int);
};

SunEvtHandler::~SunEvtHandler()
{
    if (port) {
	port->FreeResources();
	SafeDelete(port);
    }
}

void SunEvtHandler::Notify(SysEventCodes, int)
{
    if (port == 0)
	return;
    SunWindowPort *p= overlayport ? overlayport : port;
    Token t;
    p->GetEvent(&t, TRUE, TRUE);
    p->Send(&t);
}

//---- SunWindowPort -----------------------------------------------------------

SunWindowPort::SunWindowPort(InpHandlerFun nf, void *priv1, void *priv2, bool ov, bool bl)
{
    Init(nf, priv1, priv2, ov, bl);
    
    SunWindowPortInit(sizeof (class SunWindowPort));
    
    if (! (ov && bl))
	gSystem->AddFileInputHandler(handler= new SunEvtHandler(this, fd));
}

void SunWindowPort::DevDestroy2()
{
    if (handler) {
	handler->Remove();
	handler= 0;
    }
}
