#ifndef GrServer_First
#define GrServer_First

#include "../WindowPort.h"
#include "Server.h"

const int MQS= 100;

class ServerPort: public WindowPort {
    int ref; 
    Point lastpos;
    int lasttime;
    Response rps[MQS+1];
    int in, out;

public:    
    Response *Dequeue();
    void Enqueue(Response*);
public:
    ServerPort(InpHandlerFun, void*, void*, bool, bool);

    void DevDestroy2();
    void DevClip(Rectangle, Point);
    void DevResetClip();
    void DevStrokeLine(GrPattern, GrMode, int, Rectangle*, GrLineCap, Point, Point);
    void DevStrokeRect(GrPattern, GrMode, int, Rectangle*);
    void DevFillRect(GrPattern, GrMode, Rectangle*);
    void DevStrokeRRect(GrPattern, GrMode, int, Rectangle*, Point);
    void DevFillRRect(GrPattern, GrMode, Rectangle*, Point);
    void DevStrokeOval(GrPattern pat, GrMode mode, int ps, Rectangle *r);
    void DevFillOval(GrPattern pat, GrMode mode, Rectangle *r);
    void DevStrokeWedge(GrPattern, GrMode, int, GrLineCap, Rectangle*, int, int);
    void DevFillWedge(GrPattern, GrMode, Rectangle*, int, int);
    void DevStrokePolygon(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType, int, GrLineCap);
    void DevFillPolygon(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType);
    void DevShowBitmap(GrPattern, GrMode, Rectangle*, struct Bitmap*);
    bool DevShowChar(FontPtr, Point, byte, bool, Point);
    void DevShowTextBatch(GrPattern, GrMode, Rectangle*, Point);
    void DevGiveHint(int, int, void*);
    void DevSetCursor(GrCursor);
    void DevHide();
    void DevShow(WindowPort *father, Rectangle);
    void DevSetRect(Rectangle*);

    void DevGrab(bool);
    
    void DevFullscreen(bool);
    void DevScrollRect(Rectangle, Point);

    void DevTop(bool);

    void DevGetEvent(Token *t, int timeout, bool overread);    
    void DevSetMousePos(Point);
    void DevMoveMousePos(Point);

    void DevBell(long);   
};

#endif GrServer_First
