#ifndef PrintDialog_First
#define PrintDialog_First

#include "Dialog.h"

//---- PrintDialog -------------------------------------------------------------

class PrintDialog : public Dialog {
    class FileDialog *saveDialog;
    class OptionDialog *optionDialog;
    class CompositeVObject *scroller;
    class CollectionView *collview;
    class OrdCollection *printers;
    class Printer *current, *lastcurrent;
    class BlankWin *window;
    class VObject *vobject;
    class NumItem *from, *to;
    char *title;
    bool showgrid, lastshowgrid;
    int lastfrom, lastto, lastprinter;
    
public:
    MetaDef(PrintDialog);
    
    PrintDialog(char *title= "Print");
    ~PrintDialog();    
    VObject *DoCreateDialog();
    void Control(int id, int, void *v);
    void Print(char*);
    int ShowPrintDialog(VObject *v);  
    void UpdateButtons();
    void ShowPageGrid(Rectangle r);
    
    void DoSetDefaults();
    void DoSave();
    void DoRestore();
    void DoSetup();
};

int ShowPrintDialog(VObject *v);

extern PrintDialog *gPrintManager;
extern bool gPrinting;

#endif PrintDialog_First

